% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sccomp_calculate_residuals.R
\name{sccomp_calculate_residuals}
\alias{sccomp_calculate_residuals}
\title{Calculate Residuals Between Observed and Predicted Proportions}
\usage{
sccomp_calculate_residuals(.data)
}
\arguments{
\item{.data}{A tibble of class \code{sccomp_tbl}, which is the result of \code{sccomp_estimate()}. This tibble contains the fitted model and associated data necessary for calculating residuals.}
}
\value{
A tibble (\code{tbl}) with the following columns:
\itemize{
\item \strong{sample} - A character column representing the sample identifiers.
\item \strong{cell_group} - A character column representing the cell group identifiers.
\item \strong{residuals} - A numeric column representing the residuals, calculated as the difference between observed and predicted proportions.
\item \strong{exposure} - A numeric column representing the total counts (sum of counts across cell groups) for each sample.
}
}
\description{
\code{sccomp_calculate_residuals} computes the residuals between observed cell group proportions and the predicted proportions from a fitted \code{sccomp} model. This function is useful for assessing model fit and identifying cell groups or samples where the model may not adequately capture the observed data. The residuals are calculated as the difference between the observed proportions and the predicted mean proportions from the model.
}
\details{
The function performs the following steps:
\enumerate{
\item Extracts the predicted mean proportions for each cell group and sample using \code{sccomp_predict()}.
\item Calculates the observed proportions from the original count data.
\item Computes residuals by subtracting the predicted proportions from the observed proportions.
\item Returns a tibble containing the sample, cell group, residuals, and exposure (total counts per sample).
}
}
\examples{
\donttest{
  if (instantiate::stan_cmdstan_exists() && .Platform$OS.type == "unix") {
# Load example data
data("counts_obj")

# Fit the sccomp model
estimates <- sccomp_estimate(
  counts_obj,
  formula_composition = ~ type,
  formula_variability = ~1,
  sample = "sample",
  cell_group = "cell_group",
  abundance = "count",
  approximate_posterior_inference = "all",
  cores = 1
)

# Calculate residuals
residuals <- sccomp_calculate_residuals(estimates)

# View the residuals
print(residuals)
}}

}
\references{
S. Mangiola, A.J. Roth-Schulze, M. Trussart, E. Zozaya-Valdés, M. Ma, Z. Gao, A.F. Rubin, T.P. Speed, H. Shim, & A.T. Papenfuss, sccomp: Robust differential composition and variability analysis for single-cell data, Proc. Natl. Acad. Sci. U.S.A. 120 (33) e2203828120, https://doi.org/10.1073/pnas.2203828120 (2023).
}
