% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndexedFst.R
\name{loadIndexedFst}
\alias{loadIndexedFst}
\alias{saveIndexedFst}
\title{Saving and loading IndexedFst}
\usage{
loadIndexedFst(file, nthreads = 1)

saveIndexedFst(
  d,
  index.by,
  file.prefix,
  nthreads = 1,
  index.properties = NULL,
  add.info = list(),
  ...
)
}
\arguments{
\item{file}{Path to the fst file, it's index (.idx), or their prefix.}

\item{nthreads}{Number of threads to use for reading (default 1). This does
not affect the loading of the index itself, but will affect all downstream
reading operations performed on the object. If NULL, will use
`fst::threads_fst()`.}

\item{d}{A data.frame or \code{\link[GenomicRanges]{GRanges}} object}

\item{index.by}{A column of `d` by which it should be indexed.}

\item{file.prefix}{Path and prefix of the output files.}

\item{index.properties}{An optional data.frame of properties, with the levels
of `index.by` as row names.}

\item{add.info}{An optional list of additional information to save.}

\item{...}{Passed to `write.fst`}
}
\value{
`loadIndexedFst` returns an object of class
\code{\link{IndexedFst-class}}, and `saveIndexedFst` returns nothing.
}
\description{
Functions to save or load and indexed \code{\link[fst]{fst}} file

Saves a data.frame (or GRanges object) into an indexed FST file.
}
\examples{
# we first create and save an indexed FST file
tmp <- tempdir()
f <- system.file(tmp, "test")
d <- data.frame( category=sample(LETTERS[1:4], 10000, replace=TRUE),
                 var2=sample(LETTERS, 10000, replace=TRUE),
                 var3=runif(10000) )
saveIndexedFst(d, "category", f)
# we then load the index, and can use category names for random access:
d <- loadIndexedFst(f)
}
\seealso{
\code{\link{IndexedFst-class}}

\code{\link{IndexedFst-class}}
}
