% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichedPairs.R
\name{enrichedMirTxPairs}
\alias{enrichedMirTxPairs}
\title{enrichedMirTxPairs}
\usage{
enrichedMirTxPairs(m, minSites = 5, max.binom.p = 0.001)
}
\arguments{
\item{m}{A GRanges of matches, as produced by \code{\link{findSeedMatches}}.
This will be filtered down to only 8mer and 7mer sites.}

\item{minSites}{The minimum number of sites for a given miRNA-target pair to
be considered.}

\item{max.binom.p}{The maximum binomial p-value of miRNA-target pairs.}
}
\value{
A data.frame of top combinations, including number of sites and
the log-transformed binomial p-value.
}
\description{
Identifies pairs of miRNA and target transcripts that have an unexpectedly
high number of sites.
}
\examples{
# we create a dummy scan (see `runFullScan`)
library(scanMiR)
seqs <- getRandomSeq(n=10)
mirs <- c("TTGTATAA","AGCATTAA")
m <- findSeedMatches(seqs,mirs,verbose=FALSE)
# we look for enriched pairs
res <- enrichedMirTxPairs(m, minSites=1, max.binom.p=1)
res
}
