% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndexedFst.R
\docType{class}
\name{IndexedFst-class}
\alias{IndexedFst-class}
\alias{IndexedFst}
\alias{show,IndexedFst-method}
\alias{summary,IndexedFst-method}
\alias{names,IndexedFst-method}
\alias{length,IndexedFst-method}
\alias{lengths,IndexedFst-method}
\alias{nrow,IndexedFst-method}
\alias{ncol,IndexedFst-method}
\alias{colnames,IndexedFst-method}
\alias{[[,IndexedFst,ANY,ANY-method}
\alias{[,IndexedFst,ANY,ANY,ANY-method}
\alias{$,IndexedFst-method}
\alias{head,IndexedFst-method}
\alias{as.data.frame,IndexedFst-method}
\title{IndexedFst}
\usage{
\S4method{show}{IndexedFst}(object)

\S4method{summary}{IndexedFst}(object)

\S4method{names}{IndexedFst}(x)

\S4method{length}{IndexedFst}(x)

\S4method{lengths}{IndexedFst}(x)

\S4method{nrow}{IndexedFst}(x)

\S4method{ncol}{IndexedFst}(x)

\S4method{colnames}{IndexedFst}(x)

\S4method{[[}{IndexedFst,ANY,ANY}(x, i, j = NULL, ...)

\S4method{[}{IndexedFst,ANY,ANY,ANY}(x, i, j = NULL, ..., drop = TRUE)

\S4method{$}{IndexedFst}(x, name)

\S4method{head}{IndexedFst}(x, n = 6L, ...)

\S4method{as.data.frame}{IndexedFst}(x, name)
}
\arguments{
\item{object}{an IndexedFst object}

\item{x}{an IndexedFst object}

\item{i}{the desired index (either numeric or name)}

\item{j, drop}{ignored}

\item{...}{ignored}

\item{name}{the indexed name to fetch}

\item{n}{the desired number of rows}
}
\value{
Depends on the method
}
\description{
Objects of the IndexedFst class enable fast named random access to FST files.
This is particularly appropriate for large data.frames which often need to
 be accessed according to the (e.g. factor) value of a particular column.
}
\examples{
# we first create and save an indexed FST file
tmp <- tempdir()
f <- system.file(tmp, "test")
d <- data.frame( category=sample(LETTERS[1:4], 10000, replace=TRUE),
                 var2=sample(LETTERS, 10000, replace=TRUE),
                 var3=runif(10000) )
format(object.size(d),units="Kb")
saveIndexedFst(d, "category", f)
rm(d)
# we then load the index, and can use category names for random access:
d <- loadIndexedFst(f)
format(object.size(d),units="Kb")
nrow(d)
names(d)
head(d$A)
}
\seealso{
\code{\link{saveIndexedFst}}, \code{\link{loadIndexedFst}}
}
\author{
Pierre-Luc Germain, \email{pierre-luc.germain@hest.ethz.ch}
}
