% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scTHI_plotResult.R
\name{scTHI_plotResult}
\alias{scTHI_plotResult}
\title{scTHI_plotResult}
\usage{
scTHI_plotResult(scTHIresult, cexNames = 0.8, plotType = c("score",
  "pair"), nRes = NULL)
}
\arguments{
\item{scTHIresult}{scTHI object.}

\item{cexNames}{Size of names in barplot.}

\item{plotType}{Type of plot to be generated. Default is
"score", can be  also "pair". The "score" option will generate
a barplot for each resulted interaction pair, representing
the calculated interaction score
  and the related p-Value.The "pair" option will generate
  two barplot for each resulted interaction pair, representing
  the percentage of cells of each cluster expressing partnerA
  and partnerB gene, respectively.}

\item{nRes}{Number of pairs to plot (all if NULL).}
}
\value{
None
}
\description{
Creates barplots of scTHI_score results.
}
\examples{
library(scTHI.data)
data(scExample)
result <-  scTHI_score(scExample,
                       cellCusterA = colnames(scExample)[1:30],
                       cellCusterB = colnames(scExample)[31:100],
                       cellCusterAName = "ClusterA",
                       cellCusterBName = "ClusterB", filterCutoff = 0,
                       pvalueCutoff = 1, nPermu = 100, ncore = 8)

scTHI_plotResult(result, plotType = "score")
scTHI_plotResult(result, plotType = "pair")
}
