% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createHTOContigList.R
\name{createHTOContigList}
\alias{createHTOContigList}
\title{Deconvolute Contig Information from Multiplexed Experiments}
\usage{
createHTOContigList(contig, sc.data, group.by = NULL, multi.run = NULL)
}
\arguments{
\item{contig}{The filtered contig annotation file from multiplexed experiment}

\item{sc.data}{The Seurat or Single-Cell Experiment object.}

\item{group.by}{One or more meta data headers to create the contig
list based on. If more than one header listed, the function combines
them into a single variable.}

\item{multi.run}{If using integrated single-cell object, the meta data
variable that indicates the sequencing run.}
}
\value{
Returns a list of contigs as input for \code{\link[=combineBCR]{combineBCR()}}
or \code{\link[=combineTCR]{combineTCR()}}
}
\description{
This function reprocess and forms a list of contigs for downstream analysis
in scRepertoire, \code{\link[=createHTOContigList]{createHTOContigList()}} take the filtered contig
annotation output and the single-cell RNA object to create the list.
If using an integrated single-cell object, it is recommended to split the
object by sequencing run and remove extra prefixes and suffixes on the
barcode before using \code{\link[=createHTOContigList]{createHTOContigList()}}. Alternatively,
the variable \code{multi.run} can be used to separate a list of contigs
by a meta data variable. This may have issues with the repeated barcodes.
}
\examples{
\dontrun{
filtered.contig <- read.csv(".../Sample/outs/filtered_contig_annotations.csv")

contig.list <- createHTOContigList(contig = filtered.contig, 
                                   sc.data = Seurat.Obj, 
                                   group.by = "HTO_maxID")
}

}
\concept{Loading_and_Processing_Contigs}
