% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalOccupy.R
\name{clonalOccupy}
\alias{clonalOccupy}
\title{Plot cloneSize by Variable in Single-Cell Objects}
\usage{
clonalOccupy(
  sc.data,
  x.axis = "ident",
  label = TRUE,
  facet.by = NULL,
  order.by = NULL,
  proportion = FALSE,
  na.include = FALSE,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{sc.data}{The single-cell object after \code{\link[=combineExpression]{combineExpression()}}}

\item{x.axis}{The variable in the meta data to graph along the x.axis.}

\item{label}{Include the number of clone in each category by x.axis variable}

\item{facet.by}{The column header used for faceting the graph}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{proportion}{Convert the stacked bars into relative proportion}

\item{na.include}{Visualize NA values or not}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
Stacked bar plot of counts of cells by clone frequency group
}
\description{
View the count of clones frequency group in Seurat or SCE object
meta data after \code{\link[=combineExpression]{combineExpression()}}. The visualization
will take the new meta data variable \code{cloneSize} and
plot the number of cells with each designation using a secondary
variable, like cluster. Credit to the idea goes to Drs. Carmona
and Andreatta and their work with \href{https://github.com/carmonalab/ProjecTILs}{ProjectTIL}.
}
\examples{
# Getting the combined contigs
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Getting a sample of a Seurat object
scRep_example <- get(data("scRep_example"))

# Using combineExpresion()
scRep_example <- combineExpression(combined, scRep_example)

# Using clonalOccupy
clonalOccupy(scRep_example, x.axis = "ident")
table <- clonalOccupy(scRep_example, x.axis = "ident", exportTable = TRUE)

}
\concept{SC_Functions}
