% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scRecover.R
\name{scRecover}
\alias{scRecover}
\title{scRecover: Imputation for single-cell RNA-seq data}
\usage{
scRecover(counts, Kcluster = NULL, labels = NULL, outputDir = NULL,
  depth = 20, SAVER = FALSE, MAGIC = FALSE, UMI = FALSE,
  hist_raw_counts = NULL, hist_RUG_counts = NULL, parallel = FALSE,
  BPPARAM = bpparam(), verbose = TRUE)
}
\arguments{
\item{counts}{A non-negative integer matrix of scRNA-seq raw read counts or a \code{SingleCellExperiment} object which contains the read counts matrix. The rows of the matrix are genes and columns are samples/cells.}

\item{Kcluster}{An integer specifying the number of cell subpopulations. This parameter can be determined based on prior knowledge or clustering of raw data. \code{Kcluster} is used to determine the candidate neighbors of each cell.}

\item{labels}{Optional. Only needed when \code{Kcluster} is blank or \code{Kcluster = NULL}. A character/integer vector specifying the cell type of each column in the raw count matrix. Each cell type should have at least two cells.}

\item{outputDir}{The path of the output directory. If not specified, a folder named with prefix 'outDir_scRecover_' under the temporary directory will be used.}

\item{depth}{Relative sequencing depth to be predicted compared with initial sample depth, should between 2-100, default is 20.}

\item{SAVER}{Whether use and improve SAVER in imputation, default is FALSE.}

\item{MAGIC}{Whether use and improve MAGIC in imputation, default is FALSE.}

\item{UMI}{Whether use full UMI data, default is FALSE. If TRUE, \code{hist_raw_counts} and \code{hist_RUG_counts} should be specified.}

\item{hist_raw_counts}{A list contains the histogram table of raw read counts for each cell in \code{counts}.}

\item{hist_RUG_counts}{A list contains the histogram table of raw UMI-gene counts for each cell in \code{counts}.}

\item{parallel}{If FALSE (default), no parallel computation is used; if TRUE, parallel computation using \code{BiocParallel}, with argument \code{BPPARAM}.}

\item{BPPARAM}{An optional parameter object passed internally to \code{\link{bplapply}} when \code{parallel=TRUE}. If not specified, \code{\link{bpparam}()} (default) will be used.}

\item{verbose}{Whether to show specific calculation progress, default is TRUE.}
}
\value{
Imputed counts matrices will be saved in the output directory specified by \code{outputDir}.
}
\description{
This function is used to impute missing values in single-cell RNA-seq (scRNA-seq) data. It takes a non-negative matrix of scRNA-seq raw read counts or a \code{SingleCellExperiment} object as input. So users should map the reads (obtained from sequencing libraries of the samples) to the corresponding genome and count the reads mapped to each gene according to the gene annotation to get the raw read counts matrix in advance.
}
\examples{
# Load test data for scRecover
data(scRecoverTest)

# Run scRecover with Kcluster specified
scRecover(counts = counts, Kcluster = 2)

# Or run scRecover with labels specified
# scRecover(counts = counts, labels = labels)


}
\seealso{
\code{\link{estDropoutNum}}, for estimating dropout gene number in a cell.

\code{\link{countsSampling}}, for downsampling the read counts in a cell.

\code{\link{normalization}}, for normalization of single-cell RNA-seq data.

\code{\link{scRecoverTest}}, a test dataset for scRecover.
}
\author{
Zhun Miao.
}
