% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDataset.R
\name{createDataSet}
\alias{createDataSet}
\title{Create a dataset
Create a dataset from a Seurat object. The function will try to find
the markers in the Misc data named as 'markers'.
The misc data should be output of function \code{FindAllMarkers}.}
\usage{
createDataSet(
  appconf,
  seu,
  config,
  contrast,
  assayName,
  gexSlot = c("data", "scale.data", "counts"),
  atacAssayName,
  atacSlot = c("data", "scale.data", "counts"),
  LOCKER = FALSE,
  datafolder = "data",
  default.symbol = "rownames",
  theme = "Paired",
  binSize = 1,
  fragmentNameMapList
)
}
\arguments{
\item{appconf}{a list object represent the information about the dataset}

\item{seu}{a Seurat object}

\item{config}{config file for makeShinyFiles}

\item{contrast}{The contrast group}

\item{assayName}{assay in single-cell data object to use for plotting
gene expression, which must match one of the following:
\itemize{
\item{Seurat objects}: "RNA" or "integrated" assay,
default is "RNA"
}}

\item{gexSlot}{layer in single-cell assay to plot.
Default is to use the "data" layer}

\item{atacAssayName}{assay in single-cell data object to use for plotting
open chromatin.}

\item{atacSlot}{layer in single-cell atac assay to plot.
Default is to use the "data" layer}

\item{LOCKER}{Set locker if the file is required login}

\item{datafolder}{app data folder}

\item{default.symbol}{character(1L) specifying the default rownames to be used. If use default, the gene symbols will be the row names of the assay. If one column name of the meta.feature of the assay is supplied, the function will try to extract the symbols from the meta.feature slot of the assay.}

\item{theme}{color theme. default is "Paired" from ColorBrewer palettes.}

\item{binSize}{number of bps for each bin for ATAC fragment coverage. Used
to reduce the file size of bigwig.}

\item{fragmentNameMapList}{list of named character vector.
The name map list must be the same order as the fragment list in the object.
For each element of the list,
the names of the vector are the name of the fragment and
the vector contains the cell names (column names of the assay).
You can try \link{extractFragmentNameMapList}.}
}
\value{
The updated Seurat object.
}
\description{
Create a dataset
Create a dataset from a Seurat object. The function will try to find
the markers in the Misc data named as 'markers'.
The misc data should be output of function \code{FindAllMarkers}.
}
\examples{
library(Seurat)
if(interactive()){
    appconf <- createAppConfig(
        title="pbmc_small",
        destinationFolder = "pbmc_small",
        species = "Homo sapiens",
        doi="10.1038/nbt.3192",
        datatype = "scRNAseq")
    createDataSet(appconf, pbmc_small, datafolder=tempdir())
}
}
