% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APPconf-class.R
\docType{class}
\name{APPconf-class}
\alias{APPconf-class}
\alias{APPconf}
\title{Class \code{"APPconf"}}
\usage{
APPconf(...)
}
\arguments{
\item{\dots}{Each argument in \dots becomes an slot in the new
\code{"APPconf"}-class.}
}
\value{
A APPconf object.
}
\description{
An object of class \code{"APPconf"} represents
the metadata for a dataset.
}
\section{Slots}{

\describe{
\item{\code{title}}{character(1). Title of the data}

\item{\code{id}}{character(1). Folder name of the data}

\item{\code{species}}{character(1). species}

\item{\code{ref}}{Reference information in a list with element bib, doi, pmid
and entry. Entry must be an object of \link[utils]{bibentry}}

\item{\code{type}}{character(1). Type of the data, scRNAseq or scATACseq.}

\item{\code{markers}}{list. A list of data.frame represents cell
markers.}

\item{\code{keywords}}{character. A vector of characters represents the
keywords of the study.}

\item{\code{groupCol}}{character. The key group column name to separate
the cells.}
}}

\examples{
appconf <- readRDS(system.file("extdata", "data",
    "pbmc_small", "appconf.rds", package="scRNAseqApp"))
appconf
}
