% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_workflow.R
\name{create_processed_report}
\alias{create_processed_report}
\title{create_processed_report}
\usage{
create_processed_report(
  outdir = ".",
  organism,
  gene_id_type,
  report_name = "report"
)
}
\arguments{
\item{outdir}{output folder.}

\item{organism}{the organism of the data. List of possible names can be retrieved using the function
`listDatasets`from `biomaRt` package. (e.g. `mmusculus_gene_ensembl` or `hsapiens_gene_ensembl`).}

\item{gene_id_type}{gene id type of the data A possible list of ids can be retrieved using the function `listAttributes` from `biomaRt` package.
the commonly used id types are `external_gene_name`, `ensembl_gene_id` or `entrezgene`.}

\item{report_name}{the name of the report .Rmd and .html files.}
}
\value{
file path of the created compiled document.
}
\description{
Create an HTML report summarising pro-processed data. This is an alternative to the more verbose \code{create_report} that requires only the processed counts and stats folders.
}
\examples{
\dontrun{
create_report(
       outdir="output_dir_of_scPipe",
       organism="mmusculus_gene_ensembl",
       gene_id_type="ensembl_gene_id")
}

}
