% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitGrid.R
\name{bpFitGrid}
\alias{bpFitGrid}
\title{Identify the Optimal Contrastive and Penalty Parameters in Parallel}
\usage{
bpFitGrid(
  target,
  target_valid = NULL,
  center,
  scale,
  c_contrasts,
  contrasts,
  penalties,
  n_eigen,
  alg,
  clust_method = c("kmeans", "pam", "hclust"),
  n_centers,
  max_iter = 10,
  linkage_method = "complete",
  clusters = NULL,
  eigdecomp_tol = 1e-10,
  eigdecomp_iter = 1000
)
}
\arguments{
\item{target}{The target (experimental) data set, in a standard format such
as a \code{data.frame} or \code{matrix}.}

\item{target_valid}{A holdout set of the target (experimental) data set, in a
standard format such as a \code{data.frame} or \code{matrix}. \code{NULL} by
default but used by \code{\link{cvSelectParams}} for cross-validated
selection of the contrastive and penalization parameters.}

\item{center}{A \code{logical} indicating whether the target and background
data sets should be centered to mean zero.}

\item{scale}{A \code{logical} indicating whether the target and background
data sets should be scaled to unit variance.}

\item{c_contrasts}{A \code{list} of contrastive covariances.}

\item{contrasts}{A \code{numeric} vector of the contrastive parameters used
to compute the contrastive covariances.}

\item{penalties}{A \code{numeric} vector of the penalty terms.}

\item{n_eigen}{A \code{numeric} indicating the number of eigenvectors to be
computed.}

\item{alg}{A \code{character} indicating the SPCA algorithm used to sparsify
the contrastive loadings. Currently supports \code{iterative} for the
\insertCite{zou2006sparse;textual}{scPCA} implemententation, \code{var_proj}
for the non-randomized \insertCite{erichson2018sparse;textual}{scPCA}
solution, and \code{rand_var_proj} fir the randomized
\insertCite{erichson2018sparse;textual}{scPCA} result.}

\item{clust_method}{A \code{character} specifying the clustering method to
use for choosing the optimal constrastive parameter. Currently, this is
limited to either k-means, partitioning around medoids (PAM), and
hierarchical clustering. The default is k-means clustering.}

\item{n_centers}{A \code{numeric} giving the number of centers to use in the
clustering algorithm.}

\item{max_iter}{A \code{numeric} giving the maximum number of iterations to
be used in k-means clustering, defaulting to 10.}

\item{linkage_method}{A \code{character} specifying the agglomerative linkage
method to be used if \code{clust_method = "hclust"}. The options are
\code{ward.D2}, \code{single}, \code{complete},
\code{average}, \code{mcquitty}, \code{median}, and \code{centroid}. The
default is \code{complete}.}

\item{clusters}{A \code{numeric} vector of cluster labels for observations in
the \code{target} data. Defaults to \code{NULL}, but is otherwise used to
identify the optimal set of hyperparameters when fitting the scPCA and the
automated version of cPCA.}

\item{eigdecomp_tol}{A \code{numeric} providing the level of precision used by
eigendecompositon calculations. Defaults to \code{1e-10}.}

\item{eigdecomp_iter}{A \code{numeric} indicating the maximum number of
interations performed by eigendecompositon calculations. Defaults to
\code{1000}.}
}
\value{
A list similar to that output by \code{\link[stats]{prcomp}}:
  \itemize{
    \item rotation - the matrix of variable loadings
    \item x - the rotated data, centred and scaled, if requested, data
    multiplied by the rotation matrix
    \item contrast - the optimal contrastive parameter
    \item penalty - the optimal L1 penalty term
  }
}
\description{
This function is used to automatically select the optimal
  contrastive parameter and L1 penalty term for scPCA based on a clustering
  algorithm and average silhouette width. Analogous to \code{\link{fitGrid}},
  but replaces all \code{lapply} calls by
  \code{\link[BiocParallel]{bplapply}}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
