% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_technoise.R
\name{.amplifyOneCell}
\alias{.amplifyOneCell}
\title{This function simulates the amplification, library prep, and the sequencing processes.}
\usage{
.amplifyOneCell(
  true_counts_1cell,
  protocol,
  rate_2cap,
  gene_len,
  amp_bias,
  rate_2PCR,
  nPCR1,
  nPCR2,
  LinearAmp,
  LinearAmp_coef,
  N_molecules_SEQ
)
}
\arguments{
\item{true_counts_1cell}{the true transcript counts for one cell (one vector)}

\item{protocol}{a string, can be "nonUMI" or "UMI"}

\item{rate_2cap}{the capture efficiency for this cell}

\item{gene_len}{gene lengths for the genes/transcripts, sampled from real human transcript length}

\item{amp_bias}{amplification bias for each gene, a vector of length ngenes}

\item{rate_2PCR}{PCR efficiency, usually very high}

\item{nPCR1}{the number of PCR cycles}

\item{nPCR2}{the number of PCR cycles}

\item{LinearAmp}{if linear amplification is used for pre-amplification step, default is FALSE}

\item{LinearAmp_coef}{the coeficient of linear amplification, that is, how many times each molecule is amplified by}

\item{N_molecules_SEQ}{number of molecules sent for sequencing; sequencing depth}
}
\value{
read counts (if protocol="nonUMI") or UMI counts (if protocol="UMI)
}
\description{
This function simulates the amplification, library prep, and the sequencing processes.
}
\keyword{internal}
