% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{subset_cell}
\alias{subset_cell}
\alias{subset_loc}
\title{Subset cell and loci}
\usage{
subset_cell(mtmutObj, cell_list)

subset_loc(mtmutObj, loc_list)
}
\arguments{
\item{mtmutObj}{a mtmutObj object}

\item{cell_list}{a list of cell barcodes}

\item{loc_list}{a list of loci}
}
\value{
a mtmutObj object with cell and loci selected
}
\description{
Functions to subset cell and loci for fitting models and plotting.
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")

## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")

## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)

## open the h5 file and create a mtmutObj object
x <- open_h5_file(f_h5)
x
## subset cell and loci
x <- subset_cell(x, x$cell_list[1:10])
x <- subset_loc(x, x$loc_list[1:10])
x
}
