% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_ensemble.R
\name{run_model_fit}
\alias{run_model_fit}
\title{Fit binomial mixture model for every candidate locus}
\usage{
run_model_fit(
  mtmutObj,
  mc.cores = getOption("mc.cores", 1L),
  bb_over_bm = TRUE,
  bb_over_bm_p = 0.05,
  bb_over_bm_adj = "fdr"
)
}
\arguments{
\item{mtmutObj}{a mtmutObj object.}

\item{mc.cores}{integer number of cores to use.}

\item{bb_over_bm}{logical weather to use binomial mixture model result to define the wildtype cells for training beta binomial model.}

\item{bb_over_bm_p}{numeric the binomial mixutre model p value threshold for selecting the wildtype cells for training beta binomial model.}

\item{bb_over_bm_adj}{string the method for adjusting the binomial mixture p value, default is "fdr".}
}
\value{
NULL, the results are saved in the h5f file.
}
\description{
Fit binomial mixture model for every candidate locus
}
\details{
This function will fit three models for every candidate locus:
\itemize{
\item{binomial mixture model}{}
\item{beta binomial model}{}
\item{binomial model}{}
}
The results are saved in the h5f file.
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")
## Load the data with parse_table function
f_h5_tmp <- tempfile(fileext = ".h5")
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)
# open the h5f file
x <- open_h5_file(f_h5)
# run the model fit
run_model_fit(x)
x
# Filter the loci based on the model fit results
x <- filter_loc(x, min_cell = 5, model = "bb", p_threshold = 0.05, p_adj_method = "fdr")
x
}
