% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{filter_loc}
\alias{filter_loc}
\title{Filter mutations}
\usage{
filter_loc(
  mtmutObj,
  min_cell = 5,
  model = "bb",
  p_threshold = 0.05,
  alt_count_threshold = 0,
  p_adj_method = "fdr"
)
}
\arguments{
\item{mtmutObj}{a mtmutObj object.}

\item{min_cell}{a integer of the minimum number of cells with mutation, the default is 5.}

\item{model}{a string of the model for mutation calling, it can be "bb", "bm" or "bi" which stands for beta binomial, binomial mixture and binomial model respectively, the default is "bb".}

\item{p_threshold}{a numeric of the p-value threshold, the default is 0.05.}

\item{alt_count_threshold}{a integer of the minimum number of alternative base count, the default is 0.}

\item{p_adj_method}{a string of the method for p-value adjustment, .
refer to \code{\link[stats]{p.adjust}}. The default is "fdr".}
}
\value{
a mtmutObj object with loc_pass and loc_filter updated.
}
\description{
This function filters the mutations based on the mutation calling model and parameters. The loci passed the filter will be saved in the h5 file, together with the filter parameters.
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")

## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")

## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)

## open the h5 file and create a mtmutObj object
x <- open_h5_file(f_h5)
run_model_fit(x)
x <- filter_loc(x, min_cell = 5, model = "bb", p_threshold = 0.05, p_adj_method = "fdr")
x
}
