% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmet_simulate.R
\name{scmet_simulate}
\alias{scmet_simulate}
\title{Simulate methylation data from scMET.}
\usage{
scmet_simulate(
  N_feat = 100,
  N_cells = 50,
  N_cpgs = 15,
  L = 4,
  X = NULL,
  w_mu = c(-0.5, -1.5),
  s_mu = 1,
  w_gamma = NULL,
  s_gamma = 0.3,
  rbf_c = 1,
  cells_range = c(0.4, 0.8),
  cpgs_range = c(0.4, 0.8)
)
}
\arguments{
\item{N_feat}{Total number of features (genomics regions).}

\item{N_cells}{Maximum number of cells.}

\item{N_cpgs}{Maximum number of CpGs per cell and feature.}

\item{L}{Total number of radial basis functions (RBFs) to fit the
mean-overdispersion trend. For L = 1, this reduces to a model that does not
correct for the mean-overdispersion relationship.}

\item{X}{Covariates which might explain variability in mean (methylation). If
X = NULL, a 2-dim matrix will be generated, first column containing
intercept term (all values = 1), and second colunn random generated
covariates.}

\item{w_mu}{Regression coefficients for covariates X. Should match number of
columns of X.}

\item{s_mu}{Standard deviation for mean parameter \code{mu}.}

\item{w_gamma}{Regression coefficients of the basis functions. Should match
the value of L. If NULL, random coefficients will be generated.}

\item{s_gamma}{Standard deviation of dispersion parameter \code{gamma}.}

\item{rbf_c}{Scale parameter for empirically computing the variance of the
RBFs.}

\item{cells_range}{Range (betwen 0 and 1) to randomly (sub)sample the number
of cells per feature.}

\item{cpgs_range}{Range (betwen 0 and 1) to randomly (sub)sample the number
of CpGs per cell and feature.}
}
\value{
A simulated dataset and additional information for reproducibility
purposes.
}
\description{
General function for simulating datasets with diverse proprties.
This for instance include, adding covariates X that explain differences in
mean methylation levels. Or also defining the trend for the mean -
overdispersion relationship.
}
\examples{
sim <- scmet_simulate(N_feat = 150, N_cells = 50, N_cpgs = 15, L = 4)

}
