% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotClusteredGenes.R
\name{plotClusteredGenes}
\alias{plotClusteredGenes}
\title{Generate tidy results from \code{\link{clusterGenes}} to use in plotting.}
\usage{
plotClusteredGenes(
  test.dyn.res = NULL,
  gene.clusters = NULL,
  pt = NULL,
  size.factor.offset = NULL,
  n.cores = 2L
)
}
\arguments{
\item{test.dyn.res}{The list returned by \code{\link{testDynamic}} - no
extra processing required. Defaults to NULL.}

\item{gene.clusters}{The data.frame returned by \code{\link{clusterGenes}}.
Defaults to NULL.}

\item{pt}{A data.frame containing the pseudotime or latent time estimates
for each cell. Defaults to NULL.}

\item{size.factor.offset}{(Optional) An offset to be used to rescale the
fitted values. Can be generated easily with
 \code{\link{createCellOffset}}. No need to provide if the GEE backend was
 used. Defaults to NULL.}

\item{n.cores}{If parallel execution is desired, how many cores should be
utilized? Defaults to 2.}
}
\value{
A \code{data.frame} with ready-to-plot tidy data. Includes columns
for gene name, pseudotime lineage,
 cell name, fitted values on link & response scale, pseudotime, &
 gene cluster.
}
\description{
Generate a table of per-lineage, per-cluster fitted values
from \code{scLANE} to be used in visualizations.
}
\details{
\itemize{
\item Due to some peculiarities of how the fitted values (on the link scale)
are generated for \code{geeM} models,
  it's not necessary to multiply them by the offset as this is done
  internally. For GLM & GEE models, the opposite is
  true, and \code{size.factor.offset} must be provided in order to rescale
  the fitted values correctly.
}
}
\examples{
\donttest{
data(sim_counts)
data(scLANE_models)
data(sim_pseudotime)
cell_offset <- createCellOffset(sim_counts)
gene_clusters <- clusterGenes(scLANE_models,
    pt = sim_pseudotime,
    size.factor.offset = cell_offset
)
library(ggplot2)
plotClusteredGenes(
    test.dyn.res = scLANE_models,
    gene.clusters = gene_clusters,
    pt = sim_pseudotime,
    n.cores = 1L
) \%>\%
    ggplot(aes(x = PT, y = FITTED, color = CLUSTER, group = GENE)) +
    facet_wrap(~ LINEAGE + CLUSTER) +
    geom_line() +
    theme_classic()
}
}
\seealso{
\code{\link{clusterGenes}}
}
\author{
Jack R. Leary
}
