% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_network_comparison.R
\name{plot_network_comparison}
\alias{plot_network_comparison}
\title{Visualize Network Comparison}
\usage{
plot_network_comparison(edge_classification, show_fp = FALSE)
}
\arguments{
\item{edge_classification}{A list output from \code{classify_edges()}
containing edge classifications and graph objects.}

\item{show_fp}{Logical. If TRUE, displays False Positive edges in a
separate plot. Default: FALSE.}
}
\value{
A \code{ggplot} object visualizing the comparison. If
\code{show_fp = TRUE}, a combined plot using patchwork is returned.
}
\description{
Creates visualization plots comparing consensus and reference networks,
showing True Positives (TP), False Negatives (FN), and optionally
False Positives (FP) edges.
}
\details{
This function requires the \strong{ggraph} and \strong{ggplot2}
packages. If \code{show_fp = TRUE}, the \strong{patchwork} package is
also required.

The plots differentiate:
\itemize{
\item TP/CE (True Positives/Confirmed Edges): Red edges present in both
\item FN/ME (False Negatives/Missing Edges): Blue edges in reference only
\item FP/EE (False Positives/Extra Edges): Edges in consensus only
}

If STRINGdb was used for reference, labels are CE/ME/EE. Otherwise,
TP/FN/FP.
}
\examples{
data(toy_counts)
data(toy_adj_matrix)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)

# Generate and symmetrize adjacency matrices (returns SummarizedExperiment)
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# Apply cutoff (returns SummarizedExperiment)
binary_se <- cutoff_adjacency(
    count_matrices = toy_counts,
    weighted_adjm_list = swadj_se,
    n = 1,
    method = "GENIE3",
    quantile_threshold = 0.95,
    nCores = 1
)

# Create consensus (returns SummarizedExperiment)
consensus <- create_consensus(binary_se, method = "union")

# Wrap reference matrix in SummarizedExperiment
ref_se <- build_network_se(list(reference = toy_adj_matrix))

# Classify edges
edge_class <- classify_edges(consensus, ref_se)

# Plot comparison
plot_network_comparison(edge_class, show_fp = FALSE)
}
