% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Plot ROC Curves for Inferred Networks}
\usage{
plotROC(predicted_se, ground_truth, plot_title, is_binary = FALSE)
}
\arguments{
\item{predicted_se}{A \linkS4class{SummarizedExperiment} object containing
predicted adjacency matrices as assays. Each matrix must share dimnames
with \code{ground_truth};entries may be binary (0/1) or continuous weights.}

\item{ground_truth}{A square binary matrix indicating true interactions (1)
in the upper triangle. Must match dims and names of each assay in
\code{predicted_se}.}

\item{plot_title}{Character string. Title for the ROC plot.}

\item{is_binary}{Logical. If \code{TRUE}, treat matrices as binary
predictions. Default \code{FALSE} for weighted predictions.}
}
\value{
A list with:\cr
\code{auc}: data frame of AUC per matrix.\cr
\code{plot}: the ROC plot (via ggplot2).
}
\description{
Computes and visualizes Receiver Operating Characteristic (ROC) curves for
predicted adjacency matrices stored in a \linkS4class{SummarizedExperiment}
object, compared against a binary ground truth network.
}
\details{
For binary matrices, a single TPR/FPR point is computed per
matrix. For weighted ones, a full ROC curve is computed from continuous
scores. Diagonals are ignored; symmetry is not enforced.
}
\examples{
data(toy_counts)
data(toy_adj_matrix)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)
head(networks[[1]])

# Generate and symmetrize adjacency matrices (returns SummarizedExperiment)
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# plotROC now accepts SummarizedExperiment directly
roc_res <- plotROC(
    swadj_se,
    toy_adj_matrix,
    plot_title = "ROC Curve: GENIE3",
    is_binary = FALSE
)
roc_res$plot
auc_joint <- roc_res$auc
}
