% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scgps_prediction_summary.R
\name{reformat_LASSO}
\alias{reformat_LASSO}
\title{summarise bootstrap runs for Lasso model, from \code{n} bootstraps}
\usage{
reformat_LASSO(
  c_selectID = NULL,
  mp_selectID = NULL,
  LSOLDA_dat = NULL,
  nPredSubpop = NULL,
  Nodes_group = "#7570b3",
  nboots = 2
)
}
\arguments{
\item{c_selectID}{is the original cluster to be projected}

\item{mp_selectID}{is the target mixedpop to project to}

\item{LSOLDA_dat}{is the results from the bootstrap}

\item{nPredSubpop}{is the number of clusters in the target mixedpop 
\code{row_cluster <-length(unique(target_cluster))}}

\item{Nodes_group}{string representation of hexidecimal color code for node}

\item{nboots}{is an integer for how many bootstraps are run}
}
\value{
a dataframe containg information for the Lasso prediction results, 
each column
contains prediction results for all subpopulations from each bootstrap run
}
\description{
the training and prediction results from \code{bootstrap}
were written to the object \code{LSOLDA_dat}, the \code{reformat_LASSO}
summarises prediction for \code{n} bootstrap runs
}
\examples{
c_selectID<-1
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
genes <-training_gene_sample
genes <-genes$Merged_unique
LSOLDA_dat <- bootstrap_prediction(nboots = 2, mixedpop1 = mixedpop1, 
    mixedpop2 = mixedpop2, genes=genes, c_selectID, listData =list(),
    cluster_mixedpop1 = colData(mixedpop1)[,1],
    cluster_mixedpop2=colData(mixedpop2)[,1])
reformat_LASSO(LSOLDA_dat=LSOLDA_dat, 
    nPredSubpop=length(unique(colData(mixedpop2)[,1])), c_selectID = 1, 
    mp_selectID =2, nboots = 2)

}
