% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainLassoLDATraining.R
\name{predicting}
\alias{predicting}
\title{Main prediction function applying the optimal ElasticNet and LDA models}
\usage{
predicting(
  listData = NULL,
  cluster_mixedpop2 = NULL,
  mixedpop2 = NULL,
  out_idx = NULL,
  standardize = TRUE,
  LDA_run = FALSE,
  c_selectID = NULL,
  log_transform = FALSE
)
}
\arguments{
\item{listData}{a \code{list} object containing trained results for the
selected subpopulation in the first mixed population}

\item{cluster_mixedpop2}{a vector of cluster assignment for mixedpop2}

\item{mixedpop2}{a \linkS4class{SingleCellExperiment} object from the target
mixed population of importance, e.g. differentially expressed genes that are
most significant}

\item{out_idx}{a number to specify index to write results into the list 
output. This is needed for running bootstrap.}

\item{standardize}{a logical of whether to standardize the data}

\item{LDA_run}{logical, if the LDA prediction is added to compare to 
ElasticNet, the LDA model needs to be trained from the training before
inputting to this prediction step}

\item{c_selectID}{a number to specify the trained cluster used for prediction}

\item{log_transform}{boolean whether log transform should be computed}
}
\value{
a \code{list} with prediction results written in to the index
\code{out_idx}
}
\description{
Predict a new mixed population after training the model for a
subpopulation in the first mixed population.
All subpopulations in the new target mixed population will be predicted, 
where each targeted subpopulation will have a transition score from the 
orginal subpopulation to the new subpopulation.
}
\examples{
c_selectID<-1
out_idx<-1
day2 <- day_2_cardio_cell_sample
mixedpop1 <-new_scGPS_object(ExpressionMatrix = day2$dat2_counts, 
    GeneMetadata = day2$dat2geneInfo, CellMetadata = day2$dat2_clusters)
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
genes <-training_gene_sample
genes <-genes$Merged_unique
listData  <- training(genes, 
    cluster_mixedpop1 = colData(mixedpop1)[, 1], mixedpop1 = mixedpop1, 
    mixedpop2 = mixedpop2, c_selectID, listData =list(), out_idx=out_idx)
listData  <- predicting(listData =listData,  mixedpop2 = mixedpop2, 
    out_idx=out_idx, cluster_mixedpop2 = colData(mixedpop2)[, 1], 
    c_selectID = c_selectID)

}
\author{
Quan Nguyen, 2017-11-25
}
