% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering.R
\name{clustering}
\alias{clustering}
\title{HC clustering for a number of resolutions}
\usage{
clustering(
  object = NULL,
  ngenes = 1500,
  windows = seq(from = 0.025, to = 1, by = 0.025),
  remove_outlier = c(0),
  nRounds = 1,
  PCA = FALSE,
  nPCs = 20,
  verbose = FALSE,
  log_transform = FALSE
)
}
\arguments{
\item{object}{is a \linkS4class{SingleCellExperiment} object from the
train mixed population}

\item{ngenes}{number of top variable genes to be used}

\item{windows}{a numeric specifying the number of windows to test}

\item{remove_outlier}{a vector containing IDs for clusters to be removed
the default vector contains 0, as 0 is the cluster with singletons}

\item{nRounds}{number of iterations to remove a selected clusters}

\item{PCA}{logical specifying if PCA is used before calculating distance 
matrix}

\item{nPCs}{number of principal components from PCA dimensional reduction to
be used}

\item{verbose}{a logical whether to display additional messages}

\item{log_transform}{boolean whether log transform should be computed}
}
\value{
clustering results
}
\description{
performs 40 clustering runs or more depending on windows
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
test <-clustering(mixedpop2, remove_outlier = c(0))
}
\author{
Quan Nguyen, 2017-11-25
}
