% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_mean_variance}
\alias{plot_mean_variance}
\title{Produce a mean expression x coefficient of variation scatter plot.}
\usage{
plot_mean_variance(df, density = TRUE, colourByBin = TRUE,
  density_color = "blue", ...)
}
\arguments{
\item{df}{A \code{tibble}, usually the output of \code{\link{calculate_cvs}} or \code{\link{bin_scdata}}.}

\item{density}{A boolean. Should a \code{density2d} geom be added to the plot?}

\item{colourByBin}{A boolean. Should feature be coloured by bin? Need a \code{bin} column in \code{df}
(i.e. the output of \code{\link{bin_scdata}}).}

\item{density_color}{Colour of the density2d curves.}

\item{...}{Further arguments are passed to \code{geom_point} such as \code{size}.}
}
\value{
A ggplot2 plot.
}
\description{
Use the output of \code{\link{calculate_cvs}} or \code{\link{bin_scdata}} and plot a feature
mean expression x coefficient of variation scatter plot. Mean expression is represented as
\code{log10(mean + 1)}. Each dot represents a feature.
Means and coefficient of variations were obtained across single cells.
Optionally, colours each dot according to the defined bins of features.
Optionally, adds a density2d geom.
}
\examples{
library(magrittr)
scData_hESC \%>\%
   calculate_cvs \%>\%
   plot_mean_variance(colourByBin = FALSE)

scData_hESC \%>\%
   calculate_cvs \%>\%
   define_top_genes(window_size = 100) \%>\%
   bin_scdata(window_size = 1000) \%>\%
   plot_mean_variance

}
\seealso{
\code{\link{calculate_cvs}}, \code{\link{bin_scdata}}
}
