% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCellSimilarityPCA.R,
%   R/plot.calculateCellSimilarityPCAObject.R
\name{calculateCellSimilarityPCA}
\alias{calculateCellSimilarityPCA}
\alias{plot.calculateCellSimilarityPCAObject}
\title{Calculate Cell Similarity Using PCA Loadings}
\usage{
calculateCellSimilarityPCA(
  sce_object,
  cell_names,
  pc_subset = 1:5,
  n_top_vars = 50,
  assay_name = "logcounts"
)

\method{plot}{calculateCellSimilarityPCAObject}(x, pc_subset = 1:5, ...)
}
\arguments{
\item{sce_object}{A \code{\linkS4class{SingleCellExperiment}} object containing expression data.}

\item{cell_names}{A character vector specifying the cell names for which to compute the similarity.}

\item{pc_subset}{A numeric vector specifying the subset of principal components to include in the plot. Default is 1:5.}

\item{n_top_vars}{An integer indicating the number of top loading variables to consider for each PC. Default is 50.}

\item{assay_name}{Name of the assay on which to perform computations. Default is "logcounts".}

\item{x}{An object of class `calculateCellSimilarityPCA` containing a dataframe of cosine similarity values
between cells and PCs.}

\item{...}{Additional arguments passed to the plotting function.}
}
\value{
A data frame containing cosine similarity values between cells for each selected principal component.

The S3 plot method returns a \code{ggplot} object representing the cosine similarity heatmap.
}
\description{
This function calculates the cosine similarity between cells based on the principal components (PCs)
obtained from PCA (Principal Component Analysis) loadings.

The S3 plot method  creates a heatmap plot to visualize the cosine similarities between cells and principal components (PCs).
}
\details{
This function calculates the cosine similarity between cells based on the loadings of the selected
principal components obtained from PCA. It extracts the rotation matrix from the PCA results of the
\code{\linkS4class{SingleCellExperiment}} object and identifies the high-loading variables for each selected PC.
Then, it computes the cosine similarity between cells using the high-loading variables for each PC.

The S3 plot method reshapes the input data frame to create a long format suitable for plotting as a heatmap. It then
creates a heatmap plot using ggplot2, where the x-axis represents the PCs, the y-axis represents the cells, and the
color intensity represents the cosine similarity values.
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Store PCA anomaly data and plots
anomaly_output <- detectAnomaly(reference_data = reference_data,
                                query_data = query_data,
                                ref_cell_type_col = "expert_annotation",
                                query_cell_type_col = "SingleR_annotation",
                                pc_subset = 1:10,
                                n_tree = 500,
                                anomaly_threshold = 0.5)
top6_anomalies <- names(sort(anomaly_output$Combined$reference_anomaly_scores,
                             decreasing = TRUE)[1:6])

# Compute cosine similarity between anomalies and top PCs
cosine_similarities <- calculateCellSimilarityPCA(reference_data,
                                                  cell_names = top6_anomalies,
                                                  pc_subset = 1:25,
                                                  n_top_vars = 50)
cosine_similarities

# Plot similarities
plot(cosine_similarities, pc_subset = 15:25)

}
\seealso{
\code{\link{plot.calculateCellSimilarityPCAObject}}

\code{\link{calculateCellSimilarityPCA}}
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
