% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_para.R
\name{extract_para}
\alias{extract_para}
\title{Extract the parameters of each cell's distribution}
\usage{
extract_para(
  sce,
  assay_use = "counts",
  marginal_list,
  n_cores,
  family_use,
  new_covariate,
  parallelization = "mcmapply",
  BPPARAM = NULL,
  data
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object.}

\item{assay_use}{A string which indicates the assay you will use in the sce. Default is 'counts'.}

\item{marginal_list}{A list of fitted regression models from \code{\link{fit_marginal}} for each gene in sce.}

\item{n_cores}{An integer. The number of cores to use.}

\item{family_use}{A string of the marginal distribution.
Must be one of 'poisson', 'nb', 'zip', 'zinb' or 'gaussian', which represent 'poisson distribution',
'negative binomial distribution', 'zero-inflated poisson distribution', 'zero-inflated negative binomial distribution',
and 'gaussian distribution' respectively.}

\item{new_covariate}{A data.frame which contains covariates of targeted simulated data from  \code{\link{construct_data}} and the
correlation group assignment for each cell in the column 'corr_group'.}

\item{parallelization}{A string indicating the specific parallelization function to use.
Must be one of 'mcmapply', 'bpmapply', or 'pbmcmapply', which corresponds to the parallelization function in the package
\code{parallel},\code{BiocParallel}, and \code{pbmcapply} respectively. The default value is 'mcmapply'.}

\item{BPPARAM}{A \code{MulticoreParam} object or NULL. When the parameter parallelization = 'mcmapply' or 'pbmcmapply',
this parameter must be NULL. When the parameter parallelization = 'bpmapply',  this parameter must be one of the
\code{MulticoreParam} object offered by the package 'BiocParallel. The default value is NULL.}

\item{data}{A dataframe which is used when fitting the gamlss model}
}
\value{
A list with the components:
\describe{
  \item{\code{mean_mat}}{A cell by feature matrix of the mean parameter.}
  \item{\code{sigma_mat}}{A cell by feature matrix of the sigma parameter (for Gaussian, the variance; for NB, the dispersion.).}
  \item{\code{zero_mat}}{A cell by feature matrix of the zero-inflation parameter (only non-zero for ZIP and ZINB).}
}
}
\description{
\code{extract_para} generates parameter matrices which determine each cell's distribution
}
\details{
The function takes the new covariate (if use) from \code{\link{construct_data}} and
marginal models from \code{\link{fit_marginal}}.
}
\examples{
  data(example_sce)
  my_data <- construct_data(
  sce = example_sce,
  assay_use = "counts",
  celltype = "cell_type",
  pseudotime = "pseudotime",
  spatial = NULL,
  other_covariates = NULL,
  corr_by = "1"
  )
  my_marginal <- fit_marginal(
  data = my_data,
  mu_formula = "s(pseudotime, bs = 'cr', k = 10)",
  sigma_formula = "1",
  family_use = "nb",
  n_cores = 1,
  usebam = FALSE
  )
  my_copula <- fit_copula(
  sce = example_sce,
  assay_use = "counts",
  marginal_list = my_marginal,
  family_use = c(rep("nb", 5), rep("zip", 5)),
  copula = "vine",
  n_cores = 1,
  input_data = my_data$dat
  )
  my_para <- extract_para(
    sce = example_sce,
    marginal_list = my_marginal,
    n_cores = 1,
    family_use = c(rep("nb", 5), rep("zip", 5)),
    new_covariate = my_data$new_covariate,
    data = my_data$dat
  )

}
