% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArtificialDoublets.R
\name{getCellPairs}
\alias{getCellPairs}
\title{getCellPairs}
\usage{
getCellPairs(
  clusters,
  n = 1000,
  ls = NULL,
  q = c(0.1, 0.9),
  selMode = "proportional",
  soft.min = 5
)
}
\arguments{
\item{clusters}{A vector of cluster labels for each cell, or a list containing
metacells and graph}

\item{n}{The number of cell pairs to obtain}

\item{ls}{Optional library sizes}

\item{q}{Library size quantiles between which to include cells (ignored if 
`ls` is NULL)}

\item{selMode}{How to decide the number of pairs of each kind to produce.
Either 'proportional' (default, proportional to the abundance of the 
underlying clusters), 'uniform' or 'sqrt'.}

\item{soft.min}{Minimum number of pairs of a given type.}
}
\value{
A data.frame with the columns
}
\description{
Given a vector of cluster labels, returns pairs of cross-cluster cells
}
\examples{
# create random labels
x <- sample(head(LETTERS), 100, replace=TRUE)
getCellPairs(x, n=6)
}
