% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atac_processing.R
\name{aggregateFeatures}
\alias{aggregateFeatures}
\title{aggregateFeatures}
\usage{
aggregateFeatures(
  x,
  dims.use = seq(2L, 12L),
  k = 1000,
  num_init = 3,
  use.mbk = NULL,
  use.subset = 20000,
  minCount = 1L,
  norm.fn = TFIDF,
  twoPass = FALSE,
  ...
)
}
\arguments{
\item{x}{A integer/numeric (sparse) matrix, or a `SingleCellExperiment`
including a `counts` assay.}

\item{dims.use}{The PCA dimensions to use for clustering rows.}

\item{k}{The approximate number of meta-features desired}

\item{num_init}{The number of initializations used for k-means clustering.}

\item{use.mbk}{Logical; whether to use minibatch k-means (see
\code{\link[mbkmeans]{mbkmeans}}). If NULL, the minibatch approach will be
used if there are more than 30000 features.}

\item{use.subset}{How many cells (columns) to use to cluster the features.}

\item{minCount}{The minimum number of counts for a region to be included.}

\item{norm.fn}{The normalization function to use on the un-clustered data (a
function taking a count matrix as a single argument and returning a matrix
of the same dimensions). \link{TFIDF} by default.}

\item{twoPass}{Logical; whether to perform the procedure twice, so in the 
second round cells are aggregated based on the meta-features of the first 
round, before re-clustering the features. Ignored if the dataset has fewer
than `use.subset` cells.}

\item{...}{Passed to \code{\link[mbkmeans]{mbkmeans}}. Can for instance be
used to pass the `BPPARAM` argument for multithreading.}
}
\value{
An aggregated version of `x` (either an array or a
`SingleCellExperiment`, depending on the input). If `x` is a 
`SingleCellExperiment`, the feature clusters will also be stored in 
`metadata(x)$featureGroups`
}
\description{
Aggregates similar features (rows).
}
