% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basetheme.R
\name{basetheme}
\alias{basetheme}
\title{Package-wide, non-user function used to set a base \code{ggplot2} theme.}
\usage{
basetheme(
  titleLabSize,
  subtitleLabSize,
  captionLabSize,
  axisLabSize,
  xlabAngle,
  xlabhjust,
  xlabvjust,
  ylabAngle,
  ylabhjust,
  ylabvjust,
  legendPosition,
  legendLabSize
)
}
\arguments{
\item{titleLabSize}{Size of plot title.}

\item{subtitleLabSize}{Size of plot subtitle.}

\item{captionLabSize}{Size of plot caption.}

\item{axisLabSize}{Size of x- and y-axis labels.}

\item{xlabAngle}{Rotation angle of x-axis labels.}

\item{xlabhjust}{Horizontal adjustment of x-axis labels.}

\item{xlabvjust}{Vertical adjustment of x-axis labels.}

\item{ylabAngle}{Rotation angle of y-axis labels.}

\item{ylabhjust}{Horizontal adjustment of y-axis labels.}

\item{ylabvjust}{Vertical adjustment of y-axis labels.}

\item{legendPosition}{Position of \code{legend ('top', 'bottom',
'left', 'right', 'none')}.}

\item{legendLabSize}{Size of plot legend text.}
}
\value{
A \code{list} object.
}
\description{
Package-wide, non-user function used to set a base \code{ggplot2} theme.
}
\details{
Package-wide, non-user function used to set a base \code{ggplot2} theme.
}
\examples{
# create a theme
th <- basetheme(
  titleLabSize = 16,
  subtitleLabSize = 12,
  captionLabSize = 12,
  axisLabSize = 16,
  xlabAngle = 0,
  xlabhjust = 0.5,
  xlabvjust = 0.5,
  ylabAngle = 0,
  ylabhjust = 0.5,
  ylabvjust = 0.5,
  legendPosition = 'none',
  legendLabSize = 12)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
