% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learningCurve.R
\name{learningCurve}
\alias{learningCurve}
\title{Fit learning curve for accuracy matrix}
\usage{
learningCurve(
  accMat,
  n,
  auto_initial = TRUE,
  a = NULL,
  b = NULL,
  c = NULL,
  d_list = NULL,
  fitmodel = c("nls", "nls_mix", "gam"),
  plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{accMat}{Matrix of accuracy rate where column indicate
different sample size}

\item{n}{Vector indicates the sample size}

\item{auto_initial}{whether automatical intialise}

\item{a}{input the parameter a starting point}

\item{b}{input the parameter a starting point}

\item{c}{input the parameter a starting point}

\item{d_list}{range of d}

\item{fitmodel}{"nls", "nls_mix", "gam"}

\item{plot}{indicates whether plot or not}

\item{verbose}{indicates whether verbose or not}
}
\value{
list of results
}
\description{
Fit learning curve for accuracy matrix
}
\examples{
set.seed(2019)
n <- seq(20, 10000, 100)
accMat <- do.call(cbind, lapply(1:length(n), function(i){
tmp_n <- rep(n[i], 50)
y <- -2/(tmp_n^0.8) + 0.95 + rnorm(length(tmp_n), 0, 0.02)
}))
res <- learningCurve(accMat = accMat, n)
N <- getN(res, acc = 0.9)

}
\author{
Yingxin Lin
}
