% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R, R/classifier.R, R/support.R
\name{checkObjectValidity}
\alias{checkObjectValidity}
\alias{checkCellTypeValidity}
\alias{checkMarkerGenesValidity}
\alias{checkParentValidity}
\alias{checkPThresValidity}
\alias{checkCaretModelValidity}
\alias{parent<-}
\alias{parent<-,scAnnotatR-method}
\alias{caret_model<-}
\alias{caret_model<-,scAnnotatR-method}
\alias{marker_genes<-}
\alias{marker_genes<-,scAnnotatR-method}
\alias{train_classifier_seurat}
\alias{train_classifier_sce}
\alias{train_classifier_from_mat}
\alias{preprocess_seurat_object}
\alias{preprocess_sce_object}
\alias{test_classifier_seurat}
\alias{test_classifier_sce}
\alias{test_classifier_from_mat}
\alias{classify_cells_seurat}
\alias{classify_cells_sce}
\alias{balance_dataset}
\alias{train_func}
\alias{transform_to_zscore}
\alias{subset_models}
\alias{select_marker_genes}
\alias{check_parent_child_coherence}
\alias{filter_cells}
\alias{construct_tag_vect}
\alias{process_parent_classifier}
\alias{make_prediction}
\alias{simplify_prediction}
\alias{verify_parent}
\alias{test_performance}
\alias{classify_clust}
\alias{download_data_file}
\title{Internal functions of scAnnotatR package}
\usage{
checkObjectValidity(object)

checkCellTypeValidity(cell_type)

checkMarkerGenesValidity(marker_genes)

checkParentValidity(parent)

checkPThresValidity(p_thres)

checkCaretModelValidity(caret_model)

parent(classifier) <- value

\S4method{parent}{scAnnotatR}(classifier) <- value

caret_model(classifier) <- value

\S4method{caret_model}{scAnnotatR}(classifier) <- value

marker_genes(classifier) <- value

\S4method{marker_genes}{scAnnotatR}(classifier) <- value

train_classifier_seurat(
  train_obj,
  cell_type,
  marker_genes,
  parent_cell = NA_character_,
  parent_classifier = NULL,
  path_to_models = "default",
  zscore = TRUE,
  seurat_tag_slot,
  seurat_parent_tag_slot = "predicted_cell_type",
  seurat_assay,
  seurat_slot,
  ambiguous_chars
)

train_classifier_sce(
  train_obj,
  cell_type,
  marker_genes,
  parent_cell = NA_character_,
  parent_classifier = NULL,
  path_to_models = "default",
  zscore = TRUE,
  sce_tag_slot,
  sce_parent_tag_slot = "predicted_cell_type",
  sce_assay,
  ambiguous_chars = NULL
)

train_classifier_from_mat(
  mat,
  tag,
  cell_type,
  marker_genes,
  parent_tag,
  parent_cell,
  parent_classifier,
  path_to_models,
  zscore,
  ambiguous_chars = NULL
)

preprocess_seurat_object(
  seurat_obj,
  seurat_assay,
  seurat_layer,
  seurat_tag_slot,
  seurat_parent_tag_slot
)

preprocess_sce_object(sce_obj, sce_assay, sce_tag_slot, sce_parent_tag_slot)

test_classifier_seurat(
  test_obj,
  classifier,
  target_cell_type = NULL,
  parent_classifier = NULL,
  path_to_models = "default",
  zscore = TRUE,
  seurat_tag_slot,
  seurat_parent_tag_slot = "predicted_cell_type",
  seurat_assay,
  seurat_layer,
  ambiguous_chars = NULL
)

test_classifier_sce(
  test_obj,
  classifier,
  target_cell_type = NULL,
  parent_classifier = NULL,
  path_to_models = "default",
  zscore = TRUE,
  sce_tag_slot,
  sce_parent_tag_slot = "predicted_cell_type",
  sce_assay,
  ambiguous_chars = NULL
)

test_classifier_from_mat(
  mat,
  tag,
  classifier,
  parent_tag,
  target_cell_type,
  parent_classifier,
  path_to_models,
  zscore,
  ambiguous_chars = NULL
)

classify_cells_seurat(
  classify_obj,
  classifiers = NULL,
  cell_types = "all",
  chunk_size = 5000,
  path_to_models = "default",
  ignore_ambiguous_result = FALSE,
  cluster_slot,
  seurat_assay,
  seurat_layer
)

classify_cells_sce(
  classify_obj,
  classifiers = NULL,
  cell_types = "all",
  chunk_size = 5000,
  path_to_models = "default",
  ignore_ambiguous_result = FALSE,
  sce_assay,
  cluster_slot = NULL
)

balance_dataset(mat, tag)

train_func(mat, tag)

transform_to_zscore(mat)

subset_models(model_list, model_names)

select_marker_genes(mat, marker_genes)

check_parent_child_coherence(
  mat,
  tag,
  pos_parent,
  parent_cell,
  cell_type,
  target_cell_type
)

filter_cells(mat, tag, ambiguous_chars = NULL)

construct_tag_vect(tag, cell_type)

process_parent_classifier(
  mat,
  parent_tag,
  parent_cell_type,
  parent_classifier,
  path_to_models,
  zscore
)

make_prediction(mat, classifier, pred_cells, ignore_ambiguous_result = TRUE)

simplify_prediction(meta.data, full_pred, classifiers)

verify_parent(mat, classifier, meta.data)

test_performance(mat, classifier, tag)

classify_clust(clusts, most_probable_cell_type)

download_data_file(verbose = FALSE)
}
\arguments{
\item{object}{The request classifier to check.}

\item{cell_type}{name of cell type}

\item{marker_genes}{list of selected marker genes}

\item{parent}{Classifier parent to check.}

\item{p_thres}{Classifier probability threshold to check.}

\item{caret_model}{Classifier to check.}

\item{classifier}{classifier}

\item{value}{the new classifier}

\item{train_obj}{SCE object}

\item{parent_cell}{name of parent cell type}

\item{parent_classifier}{\code{\link{scAnnotatR}} object corresponding
to classification model for the parent cell type}

\item{path_to_models}{path to databases, or by default}

\item{zscore}{boolean indicating the transformation of gene expression
in object to zscore or not}

\item{seurat_tag_slot}{string, name of annotation slot
indicating cell tag/label in the testing object.
Strings indicating cell types are expected in this slot.
Expected values are string (A-Z, a-z, 0-9, no special character accepted)
or binary/logical, 0/"no"/F/FALSE: not being new cell type,
1/"yes"/T/TRUE: being new cell type.}

\item{seurat_parent_tag_slot}{string, name of tag slot in cell meta data
indicating pre-assigned/predicted parent cell type.
Default field is "predicted_cell_type".
The slot must contain only string values.}

\item{seurat_assay}{name of assay to use in Seurat object}

\item{seurat_slot}{type of expression data to use in training object}

\item{ambiguous_chars}{Vector of character (sequences) that if 
contained within a cell type mark this
cell type as being ambiguous. If NULL
default values are used. Charactes with
a meaning in REGEX must be enclosed by
[]. F.e. "[+]". Default value is
"/", ",", " -", " [+]", "[.]", " and ",
" or ", "_or_", "-or-", "[(]" ,"[)]", 
"ambiguous"}

\item{sce_tag_slot}{string, name of annotation slot
indicating cell tag/label in the testing object.
Strings indicating cell types are expected in this slot.
Expected values are string (A-Z, a-z, 0-9, no special character accepted)
or binary/logical, 0/"no"/F/FALSE: not being new cell type,
1/"yes"/T/TRUE: being new cell type.}

\item{sce_parent_tag_slot}{string, name of tag slot in cell meta data
indicating pre-assigned/predicted parent cell type.
Default field is "predicted_cell_type".
The slot must contain only string values.}

\item{sce_assay}{name of assay to use in SCE object}

\item{mat}{expression matrix}

\item{tag}{tag of data}

\item{parent_tag}{vector, named list indicating pre-assigned/predicted
parent cell type}

\item{seurat_obj}{Seurat object}

\item{seurat_layer}{type of expression data to use in Seurat object.
Some available types are: "counts", "data" and "scale.data".}

\item{sce_obj}{Seurat object}

\item{test_obj}{SCE object used for testing}

\item{target_cell_type}{alternative cell types (in case of testing classifier)}

\item{classify_obj}{the SCE object containing cells to be classified}

\item{classifiers}{classifiers}

\item{cell_types}{list of cell types containing models to be used
for classification, only applicable if the models have been saved to package.}

\item{chunk_size}{size of data chunks to be predicted separately.
This option is recommended for large datasets to reduce running time.
Default value at 5000, because smaller datasets can be predicted rapidly.}

\item{ignore_ambiguous_result}{whether ignore ambigouous result}

\item{cluster_slot}{name of slot in meta data containing cluster
information, in case users want to have additional cluster-level
prediction}

\item{model_list}{A list of models}

\item{model_names}{The names of the models to retain}

\item{pos_parent}{a vector indicating parent classifier prediction}

\item{parent_cell_type}{name of parent cell type}

\item{pred_cells}{a whole prediction for all cells}

\item{meta.data}{object meta data}

\item{full_pred}{full prediction}

\item{clusts}{cluster info}

\item{most_probable_cell_type}{predicted cell type}

\item{verbose}{logical indicating downloading the file or not}
}
\value{
TRUE if the classifier is valid or the reason why it is not

TRUE if the cell type is valid or the reason why it is not.

TRUE if the marker_genes is valid or the reason why it is not.

TRUE if the parent is valid or the reason why it is not.

TRUE if the p_thres is valid or the reason why it is not.

TRUE if the classifier is valid or the reason why it is not.

the classifier with the new parent.

scAnnotatR object with the new parent

the classifier with the new core caret model.

scAnnotatR object with the new trained classifier.

the classifier with the new marker genes

scAnnotatR object with the new marker genes.

\code{\link{scAnnotatR}} object

\code{\link{scAnnotatR}} object

caret trained model

a list containing: expression matrix of size n x m, n: genes, m: cells;
a vector indicating cell type, and a vector containing parent cell type.

a list containing: expression matrix of size n x m, n: genes, m: cells;
a vector indicating cell type, and a vector containing parent cell type.

result of testing process in form of a list,
including predicted values, prediction accuracy at a probability threshold,
and roc curve information.

result of testing process in form of a list,
including predicted values, prediction accuracy at a probability threshold,
and roc curve information.

model performance statistics

the input object with new slots in cells meta data
New slots are: predicted_cell_type, most_probable_cell_type,
slots in form of [cell_type]_p, [cell_type]_class, and clust_pred
(if cluster_slot was provided).

the input object with new slots in cells meta data
New slots are: predicted_cell_type, most_probable_cell_type,
slots in form of [cell_type]_p, [cell_type]_class, and clust_pred
(if cluster_slot was provided).

a list of balanced count matrix
and corresponding tags of balanced count matrix

the classification model (caret object)

row wise center-scaled count matrix

The list containing the selected models

filtered matrix

list of adjusted tag

filtered matrix and corresponding tag

a binary vector for cell tag

list of cells which are positive to parent classifier

prediction

simplified prediction

applicable matrix

classifier performance

model list object
}
\description{
Check if a scAnnotatR object is valid

Train a classifier for a new cell type
If cell type has a parent, only available for \code{\link{scAnnotatR}}
object as parent cell classifying model.

Train a classifier for a new cell type
If cell type has a parent, only available for \code{\link{scAnnotatR}}
object as parent cell classifying model.

Train a classifier for a new cell type from expression matrix
and tag
If cell type has a parent, only available for \code{\link{scAnnotatR}}
object as parent cell classifying model.

Preprocess Seurat object to produce expression matrix,
tag, parent cell tag.

Preprocess Seurat object to produce expression matrix,
tag, parent cell tag.

Testing process when test object is of type Seurat

Testing process when test object is of type SCE

Testing process from matrix and tag

This function ensures that parent classifiers
are also selected.
}
