% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{locateKmers}
\alias{locateKmers}
\title{Locate occurrences of specified k-mers}
\usage{
locateKmers(kmers, seqs, directional = TRUE, showMatch = FALSE)
}
\arguments{
\item{kmers}{character vector or XStringSet of k-mers to search for}

\item{seqs}{named character vector or XStringSet of sequences in
which to locate kmer}

\item{directional}{logical value: if FALSE, counts occurrences of
either kmers or their reverse-complements. Makes sense only if
applying to DNA sequences!}

\item{showMatch}{logical value; if true add additional column to
output indicating what the exact regex match for each
occurrence (can be slow)}
}
\value{
data.frame with three columns: `seqid' containing the name
    of the sequence from seqs in which the k-mer was found; `kmer'
    indicating the k-mer located; and `location' giving the 1-based
    position at which the match was found.
}
\description{
Find locations of matches of vector of k-mers in each element of a
named character vector. Not case sensitive.
}
\examples{
data(simulatedSeqs)
kmerLoci <- locateKmers(c('AAAAA', 'CATACTGAGA'), simulatedSeqs)

}
