% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_GSnetwork.R
\name{plot_gs_network}
\alias{plot_gs_network}
\title{Plot significantly perturbed gene-sets as a network}
\usage{
plot_gs_network(
  normalisedScores,
  gsTopology,
  colorBy = NULL,
  foldGSname = TRUE,
  foldafter = 2,
  labelFun = .rm_prefix,
  layout = c("fr", "dh", "gem", "graphopt", "kk", "lgl", "mds", "sugiyama"),
  edgeAlpha = 0.8,
  edgeWidthScale = c(0.5, 3),
  edgeLegend = FALSE,
  nodeSizeScale = c(3, 6),
  nodeShape = 16,
  showLegend = TRUE,
  gsLegTitle = NULL,
  gsNameSize = 3,
  gsNameColor = "black",
  plotIsolated = FALSE,
  maxOverlaps = 10,
  ...
)
}
\arguments{
\item{normalisedScores}{A \code{data.frame} of pathway perturbation scores derived
from the \code{normalise_by_permu()} function}

\item{gsTopology}{List of pathway topology matrices generated using function
\code{retrieve_topology()}}

\item{colorBy}{Choose to color nodes either by \emph{robustZ} or \emph{pvalue}. A
column must exist in the \code{normalisedScores} \code{data.frame} for the chosen
parameter}

\item{foldGSname}{logical(1) Should long gene-set names fold across multiple
lines}

\item{foldafter}{The number of words after which gene-set names should be
folded. Defaults to 2}

\item{labelFun}{function to manipulate or modify gene-set labels. By default,
any database will be stripped from the prefix using a regex pattern}

\item{layout}{The layout algorithm to apply. Accept all layout supported by
\code{igraph}}

\item{edgeAlpha}{numeric(1) Transparency of edges. Default to 0.8}

\item{edgeWidthScale}{A numerical vector of length 2 to be provided to
\code{ggraph::scale_edge_width_continuous()} for specifying
the minimum and maximum edge widths after transformation. Defaults to
\code{c(0.5, 3)}}

\item{edgeLegend}{logical(1) Should edge weight legend be shown}

\item{nodeSizeScale}{A numeric vector of length 2 to be provided to
\code{ggplot2::scale_size()} for specifying the minimum and maximum node sizes
after transformation. Defaulted to \code{c(3,6)}}

\item{nodeShape}{Shape of nodes}

\item{showLegend}{logical(1) Should color legend be shown}

\item{gsLegTitle}{Optional title for the color legend}

\item{gsNameSize}{Size of node text labels}

\item{gsNameColor}{Color of node text labels}

\item{plotIsolated}{logical(1) Should nodes not connected to any other nodes
be plotted.  Defaults to FALSE}

\item{maxOverlaps}{passed to \link[ggraph]{geom_node_text}}

\item{...}{Not used}
}
\value{
A ggplot2 object
}
\description{
Plot significantly perturbed gene-sets as a network
}
\examples{
load(system.file("extdata", "gsTopology.rda", package = "sSNAPPY"))
load(system.file("extdata", "normalisedScores.rda", package = "sSNAPPY"))

# Subset pathways significantly perturbed in sample R5020_N2_48
subset <- dplyr::filter(
  normalisedScores, adjPvalue < 0.05, sample == "R5020_N2_48"
)
subset[["status"]] <- ifelse(subset[["robustZ"]]> 0, "Activated", "Inhibited")


# Color network plot nodes by status
plot_gs_network(subset, gsTopology,
colorBy = "status", layout = "dh",
gsLegTitle = "Direction of pathway Perturbation")

# Color network plot nodes by p-values
plot_gs_network(subset, gsTopology, layout = "dh",
colorBy = "pvalue", gsLegTitle = "P-value")

}
