% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genePertScore.R
\name{pathway_pert}
\alias{pathway_pert}
\title{Compute Single-sample Pathway-level Perturbation Score}
\usage{
pathway_pert(genePertScore, weightedFC, drop = TRUE)
}
\arguments{
\item{genePertScore}{List of gene-wise raw perturbation score matrices
generated using function \code{raw_gene_pert()}}

\item{weightedFC}{A matrix of weighted ssFC generated using function \code{weight_ss_fc}}

\item{drop}{logic(1). Whether to drop pathways with all zero scores}
}
\value{
A data.frame with 3 columns: score (single-sample pathway-level perturbation score), sample, and gs_name (gene-set name)
}
\description{
Substract ssFC from the raw gene-level perturbation scores within
each sample and sum gene-wise raw perturbation scores to derive single-sample
perturbation scores for each pathway.
}
\examples{
#compute weighted single sample logFCs
data(metadata_example)
data(logCPM_example)
metadata_example <- dplyr::mutate(metadata_example, treatment = factor(
   treatment, levels = c("Vehicle", "E2+R5020", "R5020")))
ls <- weight_ss_fc(logCPM_example, metadata = metadata_example,
groupBy = "patient", treatColumn = "treatment", sampleColumn = "sample")
# extract all the KEGG pathways
gsTopology <- retrieve_topology(database = "kegg", species = "hsapiens")
# compute raw gene-wise perturbation scores
genePertScore <- raw_gene_pert(ls$weighted_logFC, gsTopology)
# sum gene-wise perturbation scores to derive the pathway-level single-sample
# perturbation scores
pathwayPertScore <- pathway_pert(genePertScore, ls$weighted_logFC)
}
\references{
Tarca AL, Draghici S, Khatri P, Hassan SS, Mittal P, Kim JS, Kim CJ, Kusanovic JP, Romero R. A novel signaling pathway impact analysis.
Bioinformatics. 2009 Jan 1;25(1):75-82.
}
