% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{plot_path}
\alias{plot_path}
\title{Display path (plot form)}
\usage{
plot_path(graph, path)
}
\arguments{
\item{graph}{The SemMed graph}

\item{path}{A vertex sequence (\code{igraph.vs}) (the path to display)}
}
\value{
A plot is created on the current graphics device
}
\description{
Plot the graph form of a path
}
\details{
All connections among nodes along the supplied path are plotted with 
nodes labeled with their name and edges labeled with their predicate.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, names = "Serum cortisol")
node_stress <- find_nodes(g_mini, names = "Chronic Stress")
paths <- find_paths(g_mini, from = node_cortisol, to = node_stress)
plot_path(g_mini, paths[[1]][[1]])

}
\seealso{
\code{\link{text_path}} for textual display of paths
}
