% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow.R
\name{grow_nodes}
\alias{grow_nodes}
\title{Obtain immediate neighbors}
\usage{
grow_nodes(graph, nodes)
}
\arguments{
\item{graph}{The SemMed graph}

\item{nodes}{A vertex sequence (\code{igraph.vs}) of nodes to be grown}
}
\value{
A vertex sequence of nodes in the neighborhood
(not including the original nodes)
}
\description{
Grow a set of nodes into its first order neighborhood.
}
\details{
\code{grow_nodes} obtains the set of immediate neighbors of the
supplied nodes using \code{igraph::ego}. Unlike \code{ego}, 
\code{grow_nodes} flattens the result from a list to an ordinary
vertex sequence and removes the original search nodes.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, name = "hypercortisolemia")
nbrs <- grow_nodes(g_mini, node_cortisol)

}
\seealso{
\code{\link{find_nodes}} for filtering out irrelevant 
nodes from this set.
}
