% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Estimate And Plot Differential Expression}
\usage{
plotROC(dat, positive, fcsign, cut = 1, constant = 0.5,
  thresholds = seq(12, 0, len = 300), arrow = FALSE, ...)
}
\arguments{
\item{dat}{A \code{rnaseqcomp} S4 class object.}

\item{positive}{A logical vector with length equivalent to row
number of matrices in \code{dat@quantData}. \code{TRUE} means true
differential and \code{FALSE} means true non-differential, while
missing value \code{NA} means unknown.}

\item{fcsign}{A numeric vector with length equivalent to row
number of matrices in \code{dat@quantData}. Only values {1, -1, 0}
are allowed. 1 means upregulated in second cell line, -1 means
downregulated in second cell line, and 0 means no change. If elements
in \code{fcsign} correspond to \code{NA} in \code{positive}, these
elements will be ignored in estimation.}

\item{cut}{A numeric cutoff used to decide if fold change should be
estimated. For a 1 vs 1 comparison, if features have signals less than
\code{cut} in both samples, their fold changes will be set to 0.
(default: 1)}

\item{constant}{A numeric constant that is added to
quantifications before fold changes calculation. (default: 0.5)}

\item{thresholds}{A numeric vector defining cutoffs on fold changes
as the points to make threshold averaging on ROC curves.
(default: seq(12, 0, len = 300))}

\item{arrow}{A logical indicating if error bars should be added to
the averaged ROC curves. (default: FALSE)}

\item{...}{Parameters for base function \code{plot}.}
}
\value{
\item{plot}{ROC plots for all the quantification pipelines.}
\item{pAUC}{A numeric vector indicating pipeline accuracy.
This is standardized partial AUC based on ranges chosen on false
positive rate.}
}
\description{
For each pipeline, differential expression is
first estimated by fold change on 1 vs. 1 comparison between
cell lines. ROC curves then are made by comparing fold changes
with predefined true differentials. Then, ROC curves from multiple
1 vs. 1 comparisons are averaged using threshold averaging
strategy. Standardized partial area under the curve (pAUC) is
reported for each pipeline.
}
\examples{
data(simdata)
condInfo <- factor(simdata$samp$condition)
repInfo <- factor(simdata$samp$replicate)
evaluationFeature <- rep(TRUE, nrow(simdata$meta))
calibrationFeature <- simdata$meta$house & simdata$meta$chr == 'chr1'
unitReference <- 1
dat <- signalCalibrate(simdata$quant, condInfo, repInfo, evaluationFeature,
calibrationFeature, unitReference, calibrationFeature2 = calibrationFeature)
plotROC(dat,simdata$meta$positive,simdata$meta$fcsign)
}
