% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_OrderSitesByLocation.R
\name{OrderSitesByLocation}
\alias{OrderSitesByLocation}
\title{Order RNA editing sites by their genomic locations.}
\usage{
OrderSitesByLocation(sites_char, output = c("dataframe", "vector"))
}
\arguments{
\item{sites_char}{A character vector of RNA editing sites. site IDs should 
be in the form of "chrAA:XXXXXXXX".}

\item{output}{Type of output data. Defaults to \code{"dataframe"}.}
}
\value{
Depends on the output type. When \code{output} is set as
  \code{"vector"}, a character vector of ordered input RNA editing sites
  will be returned. When \code{output} is set as \code{"dataframe"}, a
  data frame of ordered RNA editing sites with following columns will be
  returned:
  \itemize{
    \item{\code{site} : }{site ID.}
    \item{\code{chr} : }{chromosome number.}
    \item{\code{pos} : }{genomic location.}
  }
}
\description{
Split RNA editing sites locations into chromosomes and 
  positions, and then order the sites by their genomic locations.
}
\examples{
  exm_sites <- c(
    "chr22:41327462", "chr22:24969087",
    "chr22:29538891", "chr22:45736763"
  )
                  
  OrderSitesByLocation(
    sites_char = exm_sites,
    output = "dataframe"
  )

}
\keyword{internal}
