% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_pos.r
\name{segment_pos}
\alias{segment_pos}
\title{\subsection{=========================================================================
segment_pos}{

segment_pos divides all IDs by position into position_segments
}}
\usage{
segment_pos(inp, dista = 300)
}
\arguments{
\item{inp}{SummarizedExperiment: the input.}

\item{dista}{integer: the amount of nucleotides defining the gap. Default
is 300.}
}
\value{
The SummarizedExperiment object:
\item{ID:}{The bin/probe specific ID}
\item{position:}{The bin/probe specific position}
\item{intensity:}{The relative intensity at time point 0}
\item{probe_TI:}{An internal value to determine which fitting model is
applied}
\item{flag:}{Information on which fitting model is applied}
\item{position_segment:}{The position based segment}
}
\description{
segment_pos adds the column "position_segment" to the rowRanges.
To reduce run time, the data is divided by regions of no expression larger
than "dist" nucleotides.
}
\examples{
data(preprocess_minimal)
segment_pos(inp = preprocess_minimal, dista = 300)

}
