% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifi_stats.r
\name{rifi_stats}
\alias{rifi_stats}
\title{rifi_stats wraps all statistical prediction steps conveniently}
\usage{
rifi_stats(inp, dista = 300, path)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}

\item{dista}{integer: the maximal distance allowed between two successive
fragments. Default is the auto generated value.}

\item{path}{path: to the directory containing the gff3 file.}
}
\value{
The SummarizedExperiment object: ID with position, strand, intensity,
probe_TI, flag, position_segment, delay, half_life, TI_termination_factor,
delay_fragment, velocity_fragment, intercept, slope, HL_fragment,
HL_mean_fragment, intensity_fragment, intensity_mean_fragment, TU,
TI_termination_fragment, TI_mean_termination_factor, seg_ID, pausing_site,
iTSS_I, ps_ts_fragment, event_ps_itss_p_value_Ttest, p_value_slope,
delay_frg_slope, velocity_ratio, event_duration, event_position, FC_HL,
FC_fragment_HL, p_value_HL, FC_intensity, FC_fragment_intensity,
p_value_intensity, FC_HL_intensity, FC_HL_intensity_fragment, FC_HL_adapted,
synthesis_ratio, synthesis_ratio_event, p_value_Manova, p_value_TI,
TI_fragments_p_value
}
\description{
rifi_stats wraps the functions:
\enumerate{
\item predict_ps_itss
\item apply_Ttest_delay
\item apply_ancova
\item apply_event_position
\item apply_t_test
\item fold_change
\item apply_manova
\item apply_t_test_ti
\item gff3_preprocess
}
}
\examples{
data(fragmentation_minimal)
rifi_stats(inp = fragmentation_minimal, dista = 300, 
path = gzfile(system.file("extdata", "gff_e_coli.gff3.gz",
package = "rifi")))

}
\seealso{
\code{predict_ps_itss}

\code{apply_Ttest_delay}

\code{apply_ancova}

\code{apply_event_position}

\code{apply_t_test}

\code{fold_change}

\code{apply_manova}

\code{apply_t_test_ti}

\code{gff3_preprocess}
}
