% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ps_itss.r
\name{predict_ps_itss}
\alias{predict_ps_itss}
\title{\subsection{=========================================================================
predict_ps_itss}{

predict_ps_itss predicts pausing sites (ps) and internal starting sites
(ITSS) between delay fragments.
}}
\usage{
predict_ps_itss(inp, maxDis = 300)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}

\item{maxDis}{integer: the maximal distance allowed between two successive
fragments.}
}
\value{
The SummarizedExperiment with the columns regarding statistics:
\describe{
\item{ID:}{The bin/probe specific ID.}
\item{position:}{The bin/probe specific position.}
\item{strand:}{The bin/probe specific strand.}
\item{intensity:}{The relative intensity at time point 0.}
\item{probe_TI:}{An internal value to determine which fitting model
is applied.}
\item{flag:}{Information on which fitting model is applied.}
\item{position_segment:}{The position based segment.}
\item{delay:}{The delay value of the bin/probe.}
\item{half_life:}{The half-life of the bin/probe.}
\item{TI_termination_factor:}{String, the factor of TI fragment.}
\item{delay_fragment:}{The delay fragment the bin belongs to.}
\item{velocity_fragment:}{The velocity value of the respective delay
fragment.}
\item{intercept:}{The vintercept of fit through the respective delay
fragment.}
\item{slope:}{The slope of the fit through the respective delay fragment.}
\item{HL_fragment:}{The half-life fragment the bin belongs to.}
\item{HL_mean_fragment:}{The mean half-life value of the respective
half-life fragment.}
\item{intensity_fragment:}{The intensity fragment the bin belongs to.}
\item{intensity_mean_fragment:}{The mean intensity value of the respective
intensity fragment.}
\item{TU:}{The overarching transcription unit.}
\item{TI_termination_fragment:}{The TI fragment the bin belongs to.}
\item{TI_mean_termination_factor:}{The mean termination factor of the
respective TI fragment.}
\item{seg_ID:}{The combined ID of the fragment.}
\item{pausing_site:}{presence of pausing site indicated by +/-.}
\item{iTSS_I:}{presence of iTSS_I indicated by +/-.}
\item{ps_ts_fragment:}{The fragments involved in pausing site or iTSS_I.}
\item{event_duration:}{Integer, the duration between two delay fragments.}
}
}
}
\description{
predict_ps_itss predicts ps and ITSS within the same TU. Neighboring delay
segments are compared to each other by positioning the intercept of the
second segment into the first segment using slope and intercept coefficients.
}
\details{
predict_ps_itss uses 3 steps to identify ps and ITSS:
\enumerate{
\item select unique TU.
\item select from the input dataframe the columns: ID, position, strand, delay.
delay fragment, TU and slope coordinates, velocity_fragment and intercept.
\item select delay segments in the TU.
\item loop into all delay segments and estimate the coordinates of the last
point of the first segment using the coefficients of the second segment
and vice versa. We get two predicted positions, the difference between
them is compared to the threshold.
}

In case the strand is "-", additional steps are added:

The positions of both segments are ordered from the last position to the
first one.

All positions are merged in one column and subtracted from the maximum
position. the column is split in 2. The first and second correspond to
the positions of the first and second segments respectively.

Both segments are subjected to lm fit and the positions predicted are used
on the same way as the opposite strand.

If the difference between the positions predicted is lower than negative
threshold, ps is assigned otherwise, and if the difference is higher than
the positive threshold, ITSS is assigned.
}
\examples{
data(fragmentation_minimal)
predict_ps_itss(inp = fragmentation_minimal, maxDis = 300) 
}
