% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_summary.r
\name{dataframe_summary}
\alias{dataframe_summary}
\title{\subsection{=========================================================================
dataframe_summary}{

dataframe_summary creates two tables relating gene annotation to fragments
}}
\usage{
dataframe_summary(data, input)
}
\arguments{
\item{data}{SummarizedExperiment: the input data frame with correct format.}

\item{input}{dataframe: dataframe from event_dataframe function.}
}
\value{
\item{bin_df:}{all information regarding bins:
\describe{
\item{position:}{Integer, position of the bin/probe on the genome}
\item{feature_type:}{String, region annotation covering the fragments}
\item{gene:}{String, gene annotation covering the fragments}
\item{locus_tag:}{String, locus_tag annotation covering the fragments}
\item{strand:}{Boolean. The bin/probe specific strand (+/-)}
\item{segment:}{String, the bin/probe segment on the genome}
\item{TU:}{String, The overarching transcription unit}
\item{delay_fragment:}{The delay fragment the bin belongs to}
\item{delay:}{Integer, the delay value of the bin/probe}
\item{HL_fragment:}{The half-life fragment the bin belongs to}
\item{half_life:}{The half-life of the bin/probe}
\item{intensity_fragment:}{The intensity fragment the bin belongs to}
\item{intensity:}{The relative intensity at time point 0}
\item{flag:}{String, the flag of the bin/probe, contains information
or the distribution for the #'different fitting models}
\item{TI_termination_factor:}{String, the TI termination factor determined by TI}
}
}
\item{frag_df:}{all information regarding fragments:
\describe{
\item{feature_type:}{String, region annotation covering the fragments}
\item{gene:}{String, gene annotation covering the fragments}
\item{locus_tag:}{String, locus_tag annotation covering the fragments}
\item{first_position_frg:}{Integer, the bin/probe specific first position}
\item{last_position_frg:}{Integer, the bin/probe specific last position}
\item{strand:}{Boolean. The bin/probe specific strand (+/-)}
\item{TU:}{String, The overarching transcription unit}
\item{segment:}{String, the bin/probe segment on the genome}
\item{delay_fragment:}{String, the delay fragment the bin belongs to}
\item{HL_fragment:}{Integer, the half_life fragment of the bin/probe belongs to}
\item{half_life:}{Integer, the half-life of the bin/probe}
\item{HL_SD:}{Integer, the half-life standard deviation of the HL fragment, bin/probe based}
\item{HL_SE:}{Integer, the half-life standard error of the HL fragment, bin/probe based}
\item{intensity_fragment:}{Integer, the intensity fragment the bin belongs to}
\item{intensity:}{Integer, the relative intensity of bin/probe at time point 0}
\item{intensity_SD:}{Integer, the intensity standard deviation of the intensity fragment, bin/probe                  based}
\item{intensity_SE:}{Integer, the intensity standard error of the intensity fragment, bin/probe based}
\item{velocity:}{The velocity value of the respective delay fragment}
}
}
}
\description{
dataframe_summary creates two tables summary of segments and their
half-lives. The first output is bin/probe features and the second one is
intensity fragment based.The dataframe_summary creates one table with
feature_type, gene, locus_tag, position, strand, TU, delay_fragment,
HL_fragment, half_life, intensity_fragment, intensity and velocity. The
second table is similar to the first one but in compact form. It contains the
same columns, the only difference is on position where a start and end
position are indicated separately.
}
\examples{
data(stats_minimal)
data(res_minimal)
dataframe_summary(data = stats_minimal, input = res_minimal)
}
