% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures_fun.r
\name{figures_fun}
\alias{figures_fun}
\title{'figures_fun': generates several plots}
\usage{
figures_fun(
  data.1,
  data.2,
  input.1,
  input.2,
  cdt1,
  cdt2,
  y = 30,
  x = 30,
  limits = c(0, 20)
)
}
\arguments{
\item{data.1}{data frame output of statistic}

\item{data.2}{data frame joining two outputs from rifi_stats by row}

\item{input.1}{data frame joining two outputs from rifi_stats by column}

\item{input.2}{data frame of differential gene expression at time 0}

\item{cdt1}{string for the first condition}

\item{cdt2}{string for the second condition}

\item{y}{integer to break the scaling in scatter plot for y_axis}

\item{x}{integer to break the scaling in scatter plot for x_axis}

\item{limits}{vector to limit the scaling in scatter plot for both axis}
}
\value{
several plots
}
\description{
'figures_fun' plots at one the density of HL, the HL category as histogram,
log2FC of decay and synthesis rate and their heatscatter. Scatter plot of HL
and volcano plot. The function uses the four output generated previously.
}
\details{
The functions used are:

plot_decay_synt: plots the changes in RNA decay rates versus the changes
in RNA synthesis rates

plot_heatscatter: plots the changes in RNA decay rates versus the changes
in RNA synthesis rates with density.

plot_volcano: plots statistical significance  versus magnitude of change .

plot_histogram: plot a histogram of probe/bin half-life categories from
2 to 20 minutes in both conditions.

plot_density: plots the probe/bin half-life density in both conditions.

plot_scatter: plots of the bin/probe half-life in one condition1 vs.
condition2.

extract the object of rifi_statistics from both conditions.
The differential gene expression at time 0 needs to be run separately.
The columns log2FC, p_value adjusted, position and strand are extracted and
saved to a data frame. loading_fun_fig joins the differential gene expression
table and the output from rifi statistics into one data frame.
}
\examples{
data(data_combined_minimal)
data(df_comb_minimal)
data(differential_expression) 
data(df_mean_minimal)
figures_fun(data.1 = df_mean_minimal, data.2 = data_combined_minimal, 
input.1 = df_comb_minimal, input.2 = differential_expression, cdt1 = "sc", 
cdt2 = "fe") 

}
