% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readsLenToKeep.R
\name{readsLenToKeep}
\alias{readsLenToKeep}
\title{Get reads length to keep by cutoff percentage}
\usage{
readsLenToKeep(readsLengthDensity, cutoff = 0.8)
}
\arguments{
\item{readsLengthDensity}{Output of \link{summaryReadsLength}}

\item{cutoff}{Cutoff value.}
}
\value{
Reads length to be kept.
}
\description{
Set the percentage to filter the reads.
}
\examples{
reads <- GRanges("chr1", ranges=IRanges(seq.int(100), width=1),
                 qwidth=sample(25:31, size = 100, replace = TRUE,
                               prob = c(.01, .01, .05, .1, .77, .05, .01)))
readsLenToKeep(summaryReadsLength(reads, plot=FALSE))
}
