% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normBy.R
\name{normBy}
\alias{normBy}
\title{Normalization by edgeR, DESeq2 or RUVSeq}
\usage{
normBy(counts, method = c("edgeR", "DESeq2", "RUVs", "fpkm", "vsn"), ...)
}
\arguments{
\item{counts}{Output of \link{countReads}}

\item{method}{Character(1L) to indicate the method for normalization.}

\item{...}{parameters will be passed to \link{normByRUVs} or \link{getFPKM}}
}
\value{
Normalized counts list
}
\description{
Normalization by multiple known methods
}
\examples{
path <- system.file("extdata", package="ribosomeProfilingQC")
cnts <- readRDS(file.path(path, "cnts.rds"))
norm <- normBy(cnts, method = 'edgeR')
norm2 <- normBy(cnts, method = 'DESeq2')
norm3 <- normBy(cnts, 'vsn')
}
