% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countReads.R
\name{countReads}
\alias{countReads}
\title{Extract counts for RPFs and RNAs}
\usage{
countReads(
  RPFs,
  RNAs,
  gtf,
  level = c("tx", "gene"),
  bestpsite = 13,
  readsLen = c(28, 29),
  anchor = "5end",
  ignore.seqlevelsStyle = FALSE,
  ...
)
}
\arguments{
\item{RPFs}{Bam file names of RPFs.}

\item{RNAs}{Bam file names of RNAseq.}

\item{gtf}{GTF file name for annotation.}

\item{level}{Transcript or gene level.}

\item{bestpsite}{numeric(1). P site postion.}

\item{readsLen}{numeric(1). reads length to keep.}

\item{anchor}{5end or 3end. Default is 5end.}

\item{ignore.seqlevelsStyle}{Ignore the sequence name style detection or not.}

\item{...}{Parameters pass to \link[Rsubread:featureCounts]{featureCounts} 
except isGTFAnnotationFile, GTF.attrType, and annot.ext.}
}
\value{
A list with reads counts.
}
\description{
Calculate the reads counts for gene level or transcript level.
}
\examples{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
RNAs <- dir(path, "mRNA.*?.[12].bam$", full.names = TRUE)
cnts <- countReads(RPFs[1], gtf=gtf, level="gene", readsLen=29)
#cnts <- countReads(RPFs[1], RNAs[1], gtf=gtf, level="gene", readsLen=29)
}
