% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ribo.R
\name{set_aliases}
\alias{set_aliases}
\title{Set the aliases of a ribo object}
\usage{
set_aliases(ribo.object, rename)
}
\arguments{
\item{ribo.object}{A 'ribo' object}

\item{rename}{A function that renames original transcript name into an alias}
}
\value{
A modified 'ribo' object that contains alias information
}
\description{
The function \code{\link{set_aliases}} allows the user to add aliases to a valid
ribo object.
}
\details{
If there is a different naming convention from the default appris transcriptome,
there may be no simple way to generate convenient aliases from the original reference names.
As a result, the user can first generate the ribo object and get the reference names, use custom
(and likely more intricate) functions to generate a list of aliases, and then pass in a character
vector of these aliases. The character vector should match the order of and correspond to the
list of reference names retrieved from \code{\link{get_reference_names}}
}
\examples{
#generate a ribo object with transcript nicknames/aliases
file.path <- system.file("extdata", "HEK293_ingolia.ribo", package = "ribor")
sample <- Ribo(file.path)
sample <- set_aliases(ribo.object = sample,
                      rename = rename_default)
}
