% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5create.R
\name{h5createAttribute}
\alias{h5createAttribute}
\title{Create HDF5 attribute}
\usage{
h5createAttribute(
  obj,
  attr,
  dims,
  maxdims = dims,
  file,
  storage.mode = "double",
  H5type = NULL,
  size = NULL,
  encoding = NULL,
  native = FALSE
)
}
\arguments{
\item{obj}{The name (character) of the object the attribute will be attached
to. For advanced programmers it is possible to provide an object of class
\linkS4class{H5IdComponent} representing a H5 object identifier (file, group,
dataset). See \code{\link[=H5Fcreate]{H5Fcreate()}}, \code{\link[=H5Fopen]{H5Fopen()}}, \code{\link[=H5Gcreate]{H5Gcreate()}}, \code{\link[=H5Gopen]{H5Gopen()}},
\code{\link[=H5Dcreate]{H5Dcreate()}}, \code{\link[=H5Dopen]{H5Dopen()}} to create an object of this kind.}

\item{attr}{Name of the attribute to be created.}

\item{dims}{The dimensions of the attribute as a numeric vector. If
\code{NULL}, a scalar dataspace will be created instead.}

\item{maxdims}{The maximum extension of the attribute.}

\item{file}{The filename (character) of the file in which the dataset will be
located. For advanced programmers it is possible to provide an object of
class \linkS4class{H5IdComponent} representing an H5 location identifier. See
\code{\link[=H5Fcreate]{H5Fcreate()}}, \code{\link[=H5Fopen]{H5Fopen()}}, \code{\link[=H5Gcreate]{H5Gcreate()}}, \code{\link[=H5Gopen]{H5Gopen()}} to create an object
of this kind. The \code{file} argument is not required, if the argument
\code{obj} is of type \code{H5IdComponent}.}

\item{storage.mode}{The storage mode of the data to be written. Can be
obtained by \code{storage.mode(mydata)}.}

\item{H5type}{Advanced programmers can specify the datatype of the dataset
within the file, either as a string with one of the available datatypes
listed in \code{h5const("H5T")}, or as the output of \code{\link[=H5Tcopy]{H5Tcopy()}}. If \code{H5type}
is specified the argument \code{storage.mode} is ignored. It is recommended
to use \code{storage.mode}.}

\item{size}{The maximum string length when \code{storage.mode='character'}.
If this is specified, HDF5 stores each string of \code{attr} as fixed
length character arrays. Together with compression, this should be
efficient.

If this argument is set to \code{NULL}, HDF5 will instead store
variable-length strings.}

\item{encoding}{The encoding of the string data type. Valid options are
"ASCII" or "UTF-8".}

\item{native}{An object of class \code{logical}. If TRUE, array-like objects
are treated as stored in HDF5 row-major rather than R column-major
orientation. Using \code{native = TRUE} increases HDF5 file portability
between programming languages. A file written with \code{native = TRUE}
should also be read with \code{native = TRUE}}
}
\value{
Returns TRUE is attribute was created successfully and FALSE
otherwise.
}
\description{
R function to create an HDF5 attribute and defining its dimensionality.
}
\details{
Creates a new attribute and attaches it to an existing HDF5 object. The
function will fail, if the file doesn't exist or if there exists already
another attribute with the same name for this object.

You can use \code{\link[=h5writeAttribute]{h5writeAttribute()}} immediately. It will create the attribute
for you.
}
\examples{

h5File <- tempfile(pattern = "ex_createAttribute.h5")
h5createFile(h5File)
h5write(1:1, h5File, "A")
fid <- H5Fopen(h5File)
did <- H5Dopen(fid, "A")
h5createAttribute(did, "time", c(1, 10))
H5Dclose(did)
H5Fclose(fid)

}
\references{
\url{https://portal.hdfgroup.org/display/HDF5}
}
\seealso{
\code{\link[=h5createFile]{h5createFile()}}, \code{\link[=h5createGroup]{h5createGroup()}}, \code{\link[=h5createDataset]{h5createDataset()}},
\code{\link[=h5read]{h5read()}}, \code{\link[=h5write]{h5write()}}, \link{rhdf5}
}
\author{
Bernd Fischer
}
\keyword{IO}
\keyword{file}
\keyword{interface}
\keyword{programming}
