% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5P.R
\name{H5Pset_fapl_ros3}
\alias{H5Pset_fapl_ros3}
\title{Set the read-only S3 virtual file driver}
\usage{
H5Pset_fapl_ros3(h5plist, s3credentials = NULL)
}
\arguments{
\item{h5plist}{\linkS4class{H5IdComponent} object representing a file access
property list.}

\item{s3credentials}{Either \code{NULL} or a list of length 3 specifying the AWS access credentials (see details).}
}
\description{
The read-only S3 virtual file driver can be used to read files hosted
remotely on Amazon's S3 storage.
}
\details{
To access files in a private Amazon S3 bucket you will need to
provide three additional details: The AWS region where the files are
hosted, your AWS access key ID, and your AWS secret access key.  More
information on how to obtain AWS access keys can be found at
\url{https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys}.
These are provided as a list to the \code{s3credentials} argument.  If you
are accessing public data this argument should be \code{NULL}.
}
\examples{

## this doesn't work on the Bioconductor Mac build machine
\dontrun{
pid <- H5Pcreate("H5P_FILE_ACCESS")
H5Pset_fapl_ros3(pid)
H5Pclose(pid)
}

}
