% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulondb-classes.R
\name{regulondb}
\alias{regulondb}
\alias{build_regulondb}
\title{Constructor function of a regulondb class}
\usage{
regulondb(database_conn, organism, genome_version, database_version)
}
\arguments{
\item{database_conn}{A
\link[RSQLite:SQLiteConnection-class]{SQLiteConnection-class} connection to
the RegulonDB database made with \code{\link[=connect_database]{connect_database()}}.}

\item{organism}{A character vector with the name of the organism of the
database.}

\item{genome_version}{A character vector with the version of the genome
build.}

\item{database_version}{A character vector with the version of regulondb
build.}
}
\value{
A \link[=regulondb]{regulondb} object.
}
\description{
The build_regulondb function is a constructor function of a
regulondb class.
}
\examples{

## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build a regulondb object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )
}
